/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.context.weaving;

import com.baidu.cloud.thirdparty.springframework.beans.BeansException;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanFactory;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanFactoryAware;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanPostProcessor;
import com.baidu.cloud.thirdparty.springframework.context.weaving.LoadTimeWeaverAware;
import com.baidu.cloud.thirdparty.springframework.instrument.classloading.LoadTimeWeaver;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;

public class LoadTimeWeaverAwareProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    @Nullable
    private LoadTimeWeaver loadTimeWeaver;
    @Nullable
    private BeanFactory beanFactory;

    public LoadTimeWeaverAwareProcessor() {
    }

    public LoadTimeWeaverAwareProcessor(@Nullable LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public LoadTimeWeaverAwareProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof LoadTimeWeaverAware) {
            LoadTimeWeaver ltw = this.loadTimeWeaver;
            if (ltw == null) {
                Assert.state(this.beanFactory != null, "BeanFactory required if no LoadTimeWeaver explicitly specified");
                ltw = this.beanFactory.getBean("loadTimeWeaver", LoadTimeWeaver.class);
            }
            ((LoadTimeWeaverAware)bean2).setLoadTimeWeaver(ltw);
        }
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String name) {
        return bean2;
    }
}

