/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.core.serializer.support;

import com.baidu.cloud.thirdparty.springframework.core.serializer.DefaultDeserializer;
import com.baidu.cloud.thirdparty.springframework.core.serializer.DefaultSerializer;
import com.baidu.cloud.thirdparty.springframework.core.serializer.Deserializer;
import com.baidu.cloud.thirdparty.springframework.core.serializer.Serializer;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerializationDelegate
implements Serializer<Object>,
Deserializer<Object> {
    private final Serializer<Object> serializer;
    private final Deserializer<Object> deserializer;

    public SerializationDelegate(ClassLoader classLoader) {
        this.serializer = new DefaultSerializer();
        this.deserializer = new DefaultDeserializer(classLoader);
    }

    public SerializationDelegate(Serializer<Object> serializer, Deserializer<Object> deserializer) {
        Assert.notNull(serializer, "Serializer must not be null");
        Assert.notNull(deserializer, "Deserializer must not be null");
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    @Override
    public void serialize(Object object, OutputStream outputStream) throws IOException {
        this.serializer.serialize(object, outputStream);
    }

    @Override
    public Object deserialize(InputStream inputStream) throws IOException {
        return this.deserializer.deserialize(inputStream);
    }
}

