/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.expression.spel.ast;

import com.baidu.cloud.thirdparty.springframework.asm.MethodVisitor;
import com.baidu.cloud.thirdparty.springframework.asm.Opcodes;
import com.baidu.cloud.thirdparty.springframework.expression.EvaluationException;
import com.baidu.cloud.thirdparty.springframework.expression.TypedValue;
import com.baidu.cloud.thirdparty.springframework.expression.common.ExpressionUtils;
import com.baidu.cloud.thirdparty.springframework.expression.spel.CodeFlow;
import com.baidu.cloud.thirdparty.springframework.expression.spel.ExpressionState;
import com.baidu.cloud.thirdparty.springframework.expression.spel.SpelEvaluationException;
import com.baidu.cloud.thirdparty.springframework.expression.spel.SpelMessage;
import com.baidu.cloud.thirdparty.springframework.expression.spel.SpelNode;
import com.baidu.cloud.thirdparty.springframework.expression.spel.ast.ValueRef;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ObjectUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public abstract class SpelNodeImpl
implements SpelNode,
Opcodes {
    private static final SpelNodeImpl[] NO_CHILDREN = new SpelNodeImpl[0];
    protected int pos;
    protected SpelNodeImpl[] children = NO_CHILDREN;
    @Nullable
    private SpelNodeImpl parent;
    @Nullable
    protected volatile String exitTypeDescriptor;

    public SpelNodeImpl(int pos, SpelNodeImpl ... operands) {
        this.pos = pos;
        Assert.isTrue(pos != 0, "Pos must not be 0");
        if (!ObjectUtils.isEmpty(operands)) {
            this.children = operands;
            for (SpelNodeImpl operand : operands) {
                Assert.notNull((Object)operand, "Operand must not be null");
                operand.parent = this;
            }
        }
    }

    protected boolean nextChildIs(Class<?> ... clazzes) {
        if (this.parent != null) {
            SpelNodeImpl[] peers = this.parent.children;
            int max = peers.length;
            for (int i = 0; i < max; ++i) {
                if (this != peers[i]) continue;
                if (i + 1 >= max) {
                    return false;
                }
                Class<?> clazz = peers[i + 1].getClass();
                for (Class<?> desiredClazz : clazzes) {
                    if (!clazz.equals(desiredClazz)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public final Object getValue(ExpressionState expressionState) throws EvaluationException {
        return this.getValueInternal(expressionState).getValue();
    }

    @Override
    public final TypedValue getTypedValue(ExpressionState expressionState) throws EvaluationException {
        return this.getValueInternal(expressionState);
    }

    @Override
    public boolean isWritable(ExpressionState expressionState) throws EvaluationException {
        return false;
    }

    @Override
    public void setValue(ExpressionState expressionState, @Nullable Object newValue) throws EvaluationException {
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.SETVALUE_NOT_SUPPORTED, this.getClass());
    }

    @Override
    public SpelNode getChild(int index) {
        return this.children[index];
    }

    @Override
    public int getChildCount() {
        return this.children.length;
    }

    @Override
    @Nullable
    public Class<?> getObjectClass(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        return obj instanceof Class ? (Class<?>)obj : obj.getClass();
    }

    @Nullable
    protected final <T> T getValue(ExpressionState state, Class<T> desiredReturnType) throws EvaluationException {
        return ExpressionUtils.convertTypedValue(state.getEvaluationContext(), this.getValueInternal(state), desiredReturnType);
    }

    @Override
    public int getStartPosition() {
        return this.pos >> 16;
    }

    @Override
    public int getEndPosition() {
        return this.pos & 0xFFFF;
    }

    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        throw new SpelEvaluationException(this.pos, SpelMessage.NOT_ASSIGNABLE, this.toStringAST());
    }

    public boolean isCompilable() {
        return false;
    }

    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        throw new IllegalStateException(this.getClass().getName() + " has no generateCode(..) method");
    }

    @Nullable
    public String getExitDescriptor() {
        return this.exitTypeDescriptor;
    }

    public abstract TypedValue getValueInternal(ExpressionState var1) throws EvaluationException;

    protected static void generateCodeForArguments(MethodVisitor mv, CodeFlow cf, Member member, SpelNodeImpl[] arguments) {
        String[] paramDescriptors = null;
        boolean isVarargs = false;
        if (member instanceof Constructor) {
            Constructor ctor = (Constructor)member;
            paramDescriptors = CodeFlow.toDescriptors(ctor.getParameterTypes());
            isVarargs = ctor.isVarArgs();
        } else {
            Method method = (Method)member;
            paramDescriptors = CodeFlow.toDescriptors(method.getParameterTypes());
            isVarargs = method.isVarArgs();
        }
        if (isVarargs) {
            int p = 0;
            int childCount = arguments.length;
            for (p = 0; p < paramDescriptors.length - 1; ++p) {
                SpelNodeImpl.generateCodeForArgument(mv, cf, arguments[p], paramDescriptors[p]);
            }
            SpelNodeImpl lastChild = childCount == 0 ? null : arguments[childCount - 1];
            String arrayType = paramDescriptors[paramDescriptors.length - 1];
            if (lastChild != null && arrayType.equals(lastChild.getExitDescriptor())) {
                SpelNodeImpl.generateCodeForArgument(mv, cf, lastChild, paramDescriptors[p]);
            } else {
                arrayType = arrayType.substring(1);
                CodeFlow.insertNewArrayCode(mv, childCount - p, arrayType);
                int arrayindex = 0;
                while (p < childCount) {
                    SpelNodeImpl child = arguments[p];
                    mv.visitInsn(89);
                    CodeFlow.insertOptimalLoad(mv, arrayindex++);
                    SpelNodeImpl.generateCodeForArgument(mv, cf, child, arrayType);
                    CodeFlow.insertArrayStore(mv, arrayType);
                    ++p;
                }
            }
        } else {
            for (int i = 0; i < paramDescriptors.length; ++i) {
                SpelNodeImpl.generateCodeForArgument(mv, cf, arguments[i], paramDescriptors[i]);
            }
        }
    }

    protected static void generateCodeForArgument(MethodVisitor mv, CodeFlow cf, SpelNodeImpl argument, String paramDesc) {
        cf.enterCompilationScope();
        argument.generateCode(mv, cf);
        String lastDesc = cf.lastDescriptor();
        Assert.state(lastDesc != null, "No last descriptor");
        boolean primitiveOnStack = CodeFlow.isPrimitive(lastDesc);
        if (primitiveOnStack && paramDesc.charAt(0) == 'L') {
            CodeFlow.insertBoxIfNecessary(mv, lastDesc.charAt(0));
        } else if (paramDesc.length() == 1 && !primitiveOnStack) {
            CodeFlow.insertUnboxInsns(mv, paramDesc.charAt(0), lastDesc);
        } else if (!paramDesc.equals(lastDesc)) {
            CodeFlow.insertCheckCast(mv, paramDesc);
        }
        cf.exitCompilationScope();
    }
}

