/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.expression.spel.ast;

import com.baidu.cloud.thirdparty.springframework.expression.TypedValue;
import com.baidu.cloud.thirdparty.springframework.expression.spel.SpelEvaluationException;
import com.baidu.cloud.thirdparty.springframework.expression.spel.SpelMessage;
import com.baidu.cloud.thirdparty.springframework.expression.spel.ast.SpelNodeImpl;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;

public interface ValueRef {
    public TypedValue getValue();

    public void setValue(@Nullable Object var1);

    public boolean isWritable();

    public static class TypedValueHolderValueRef
    implements ValueRef {
        private final TypedValue typedValue;
        private final SpelNodeImpl node;

        public TypedValueHolderValueRef(TypedValue typedValue, SpelNodeImpl node) {
            this.typedValue = typedValue;
            this.node = node;
        }

        @Override
        public TypedValue getValue() {
            return this.typedValue;
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            throw new SpelEvaluationException(this.node.pos, SpelMessage.NOT_ASSIGNABLE, this.node.toStringAST());
        }

        @Override
        public boolean isWritable() {
            return false;
        }
    }

    public static class NullValueRef
    implements ValueRef {
        static final NullValueRef INSTANCE = new NullValueRef();

        @Override
        public TypedValue getValue() {
            return TypedValue.NULL;
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            throw new SpelEvaluationException(0, SpelMessage.NOT_ASSIGNABLE, "null");
        }

        @Override
        public boolean isWritable() {
            return false;
        }
    }
}

