/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.format.support;

import com.baidu.cloud.thirdparty.springframework.core.convert.support.DefaultConversionService;
import com.baidu.cloud.thirdparty.springframework.format.FormatterRegistry;
import com.baidu.cloud.thirdparty.springframework.format.datetime.DateFormatterRegistrar;
import com.baidu.cloud.thirdparty.springframework.format.datetime.joda.JodaTimeFormatterRegistrar;
import com.baidu.cloud.thirdparty.springframework.format.datetime.standard.DateTimeFormatterRegistrar;
import com.baidu.cloud.thirdparty.springframework.format.number.NumberFormatAnnotationFormatterFactory;
import com.baidu.cloud.thirdparty.springframework.format.number.money.CurrencyUnitFormatter;
import com.baidu.cloud.thirdparty.springframework.format.number.money.Jsr354NumberFormatAnnotationFormatterFactory;
import com.baidu.cloud.thirdparty.springframework.format.number.money.MonetaryAmountFormatter;
import com.baidu.cloud.thirdparty.springframework.format.support.FormattingConversionService;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringValueResolver;

public class DefaultFormattingConversionService
extends FormattingConversionService {
    private static final boolean jsr354Present = ClassUtils.isPresent("javax.money.MonetaryAmount", DefaultFormattingConversionService.class.getClassLoader());
    private static final boolean jodaTimePresent = ClassUtils.isPresent("org.joda.time.LocalDate", DefaultFormattingConversionService.class.getClassLoader());

    public DefaultFormattingConversionService() {
        this(null, true);
    }

    public DefaultFormattingConversionService(boolean registerDefaultFormatters) {
        this(null, registerDefaultFormatters);
    }

    public DefaultFormattingConversionService(@Nullable StringValueResolver embeddedValueResolver, boolean registerDefaultFormatters) {
        if (embeddedValueResolver != null) {
            this.setEmbeddedValueResolver(embeddedValueResolver);
        }
        DefaultConversionService.addDefaultConverters(this);
        if (registerDefaultFormatters) {
            DefaultFormattingConversionService.addDefaultFormatters(this);
        }
    }

    public static void addDefaultFormatters(FormatterRegistry formatterRegistry) {
        formatterRegistry.addFormatterForFieldAnnotation(new NumberFormatAnnotationFormatterFactory());
        if (jsr354Present) {
            formatterRegistry.addFormatter(new CurrencyUnitFormatter());
            formatterRegistry.addFormatter(new MonetaryAmountFormatter());
            formatterRegistry.addFormatterForFieldAnnotation(new Jsr354NumberFormatAnnotationFormatterFactory());
        }
        new DateTimeFormatterRegistrar().registerFormatters(formatterRegistry);
        if (jodaTimePresent) {
            new JodaTimeFormatterRegistrar().registerFormatters(formatterRegistry);
        } else {
            new DateFormatterRegistrar().registerFormatters(formatterRegistry);
        }
    }
}

