/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.client.reactive;

import com.baidu.cloud.thirdparty.reactivestreams.Publisher;
import com.baidu.cloud.thirdparty.springframework.http.HttpCookie;
import com.baidu.cloud.thirdparty.springframework.http.HttpHeaders;
import com.baidu.cloud.thirdparty.springframework.http.client.reactive.ClientHttpRequest;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.LinkedMultiValueMap;
import com.baidu.cloud.thirdparty.springframework.util.MultiValueMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractClientHttpRequest
implements ClientHttpRequest {
    private final HttpHeaders headers;
    private final MultiValueMap<String, HttpCookie> cookies;
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final List<Supplier<? extends Publisher<Void>>> commitActions = new ArrayList<Supplier<? extends Publisher<Void>>>(4);

    public AbstractClientHttpRequest() {
        this(new HttpHeaders());
    }

    public AbstractClientHttpRequest(HttpHeaders headers) {
        Assert.notNull((Object)headers, "HttpHeaders must not be null");
        this.headers = headers;
        this.cookies = new LinkedMultiValueMap<String, HttpCookie>();
    }

    @Override
    public HttpHeaders getHeaders() {
        if (State.COMMITTED.equals((Object)this.state.get())) {
            return HttpHeaders.readOnlyHttpHeaders(this.headers);
        }
        return this.headers;
    }

    @Override
    public MultiValueMap<String, HttpCookie> getCookies() {
        if (State.COMMITTED.equals((Object)this.state.get())) {
            return CollectionUtils.unmodifiableMultiValueMap(this.cookies);
        }
        return this.cookies;
    }

    @Override
    public void beforeCommit(Supplier<? extends Mono<Void>> action) {
        Assert.notNull(action, "Action must not be null");
        this.commitActions.add(action);
    }

    @Override
    public boolean isCommitted() {
        return this.state.get() != State.NEW;
    }

    protected Mono<Void> doCommit() {
        return this.doCommit(null);
    }

    protected Mono<Void> doCommit(@Nullable Supplier<? extends Publisher<Void>> writeAction) {
        if (!this.state.compareAndSet(State.NEW, State.COMMITTING)) {
            return Mono.empty();
        }
        this.commitActions.add(() -> Mono.fromRunnable(() -> {
            this.applyHeaders();
            this.applyCookies();
            this.state.set(State.COMMITTED);
        }));
        if (writeAction != null) {
            this.commitActions.add(writeAction);
        }
        List actions = this.commitActions.stream().map(Supplier::get).collect(Collectors.toList());
        return Flux.concat(actions).then();
    }

    protected abstract void applyHeaders();

    protected abstract void applyCookies();

    private static enum State {
        NEW,
        COMMITTING,
        COMMITTED;

    }
}

