/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.client.reactive;

import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBuffer;
import com.baidu.cloud.thirdparty.springframework.http.HttpHeaders;
import com.baidu.cloud.thirdparty.springframework.http.HttpStatus;
import com.baidu.cloud.thirdparty.springframework.http.ResponseCookie;
import com.baidu.cloud.thirdparty.springframework.http.client.reactive.ClientHttpResponse;
import com.baidu.cloud.thirdparty.springframework.http.client.reactive.ReactorClientHttpConnector;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.LinkedMultiValueMap;
import com.baidu.cloud.thirdparty.springframework.util.MultiValueMap;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.http.client.HttpClientResponse;

class ReactorClientHttpResponse
implements ClientHttpResponse {
    private final HttpClientResponse response;
    private final AtomicBoolean bodyConsumed = new AtomicBoolean();

    public ReactorClientHttpResponse(HttpClientResponse response) {
        this.response = response;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.response.receive().doOnSubscribe(s -> Assert.state(this.bodyConsumed.compareAndSet(false, true), "The client response body can only be consumed once.")).map(byteBuf -> {
            byte[] data = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(data);
            return ReactorClientHttpConnector.BUFFER_FACTORY.wrap(data);
        });
    }

    @Override
    public HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        this.response.responseHeaders().entries().forEach(e -> headers.add((String)e.getKey(), (String)e.getValue()));
        return headers;
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf(this.getRawStatusCode());
    }

    @Override
    public int getRawStatusCode() {
        return this.response.status().code();
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        this.response.cookies().values().stream().flatMap(Collection::stream).forEach(cookie -> result.add(cookie.name(), ResponseCookie.from(cookie.name(), cookie.value()).domain(cookie.domain()).path(cookie.path()).maxAge(cookie.maxAge()).secure(cookie.isSecure()).httpOnly(cookie.isHttpOnly()).build()));
        return CollectionUtils.unmodifiableMultiValueMap(result);
    }

    public String toString() {
        return "ReactorClientHttpResponse{request=[" + this.response.method().name() + " " + this.response.uri() + "],status=" + this.getRawStatusCode() + '}';
    }
}

