/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.codec.support;

import com.baidu.cloud.thirdparty.springframework.core.codec.ByteArrayDecoder;
import com.baidu.cloud.thirdparty.springframework.core.codec.ByteArrayEncoder;
import com.baidu.cloud.thirdparty.springframework.core.codec.ByteBufferDecoder;
import com.baidu.cloud.thirdparty.springframework.core.codec.ByteBufferEncoder;
import com.baidu.cloud.thirdparty.springframework.core.codec.CharSequenceEncoder;
import com.baidu.cloud.thirdparty.springframework.core.codec.DataBufferDecoder;
import com.baidu.cloud.thirdparty.springframework.core.codec.DataBufferEncoder;
import com.baidu.cloud.thirdparty.springframework.core.codec.Decoder;
import com.baidu.cloud.thirdparty.springframework.core.codec.Encoder;
import com.baidu.cloud.thirdparty.springframework.core.codec.ResourceDecoder;
import com.baidu.cloud.thirdparty.springframework.core.codec.StringDecoder;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBuffer;
import com.baidu.cloud.thirdparty.springframework.http.codec.CodecConfigurer;
import com.baidu.cloud.thirdparty.springframework.http.codec.DecoderHttpMessageReader;
import com.baidu.cloud.thirdparty.springframework.http.codec.EncoderHttpMessageWriter;
import com.baidu.cloud.thirdparty.springframework.http.codec.FormHttpMessageReader;
import com.baidu.cloud.thirdparty.springframework.http.codec.HttpMessageReader;
import com.baidu.cloud.thirdparty.springframework.http.codec.HttpMessageWriter;
import com.baidu.cloud.thirdparty.springframework.http.codec.ResourceHttpMessageWriter;
import com.baidu.cloud.thirdparty.springframework.http.codec.json.Jackson2JsonDecoder;
import com.baidu.cloud.thirdparty.springframework.http.codec.json.Jackson2JsonEncoder;
import com.baidu.cloud.thirdparty.springframework.http.codec.json.Jackson2SmileDecoder;
import com.baidu.cloud.thirdparty.springframework.http.codec.json.Jackson2SmileEncoder;
import com.baidu.cloud.thirdparty.springframework.http.codec.support.BaseCodecConfigurer;
import com.baidu.cloud.thirdparty.springframework.http.codec.xml.Jaxb2XmlDecoder;
import com.baidu.cloud.thirdparty.springframework.http.codec.xml.Jaxb2XmlEncoder;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class BaseDefaultCodecs
implements CodecConfigurer.DefaultCodecs {
    static final boolean jackson2Present = ClassUtils.isPresent("com.baidu.cloud.thirdparty.jackson.databind.ObjectMapper", BaseCodecConfigurer.class.getClassLoader()) && ClassUtils.isPresent("com.baidu.cloud.thirdparty.jackson.core.JsonGenerator", BaseCodecConfigurer.class.getClassLoader());
    private static final boolean jackson2SmilePresent = ClassUtils.isPresent("com.baidu.cloud.thirdparty.jackson.dataformat.smile.SmileFactory", BaseCodecConfigurer.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent("javax.xml.bind.Binder", BaseCodecConfigurer.class.getClassLoader());
    @Nullable
    private Decoder<?> jackson2JsonDecoder;
    @Nullable
    private Encoder<?> jackson2JsonEncoder;
    private boolean registerDefaults = true;

    BaseDefaultCodecs() {
    }

    @Override
    public void jackson2JsonDecoder(Decoder<?> decoder) {
        this.jackson2JsonDecoder = decoder;
    }

    @Override
    public void jackson2JsonEncoder(Encoder<?> encoder) {
        this.jackson2JsonEncoder = encoder;
    }

    void registerDefaults(boolean registerDefaults) {
        this.registerDefaults = registerDefaults;
    }

    final List<HttpMessageReader<?>> getTypedReaders() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList readers = new ArrayList();
        readers.add(new DecoderHttpMessageReader<byte[]>(new ByteArrayDecoder()));
        readers.add(new DecoderHttpMessageReader<ByteBuffer>(new ByteBufferDecoder()));
        readers.add(new DecoderHttpMessageReader<DataBuffer>(new DataBufferDecoder()));
        readers.add(new DecoderHttpMessageReader<Resource>(new ResourceDecoder()));
        readers.add(new DecoderHttpMessageReader<String>(StringDecoder.textPlainOnly()));
        readers.add(new FormHttpMessageReader());
        this.extendTypedReaders(readers);
        return readers;
    }

    protected void extendTypedReaders(List<HttpMessageReader<?>> typedReaders) {
    }

    final List<HttpMessageReader<?>> getObjectReaders() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList readers = new ArrayList();
        if (jackson2Present) {
            readers.add(new DecoderHttpMessageReader(this.getJackson2JsonDecoder()));
        }
        if (jackson2SmilePresent) {
            readers.add(new DecoderHttpMessageReader<Object>(new Jackson2SmileDecoder()));
        }
        if (jaxb2Present) {
            readers.add(new DecoderHttpMessageReader<Object>(new Jaxb2XmlDecoder()));
        }
        this.extendObjectReaders(readers);
        return readers;
    }

    protected void extendObjectReaders(List<HttpMessageReader<?>> objectReaders) {
    }

    final List<HttpMessageReader<?>> getCatchAllReaders() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        result.add(new DecoderHttpMessageReader<String>(StringDecoder.allMimeTypes()));
        return result;
    }

    final List<HttpMessageWriter<?>> getTypedWriters(boolean forMultipart) {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList writers = new ArrayList();
        writers.add(new EncoderHttpMessageWriter<byte[]>(new ByteArrayEncoder()));
        writers.add(new EncoderHttpMessageWriter<ByteBuffer>(new ByteBufferEncoder()));
        writers.add(new EncoderHttpMessageWriter<DataBuffer>(new DataBufferEncoder()));
        writers.add(new ResourceHttpMessageWriter());
        writers.add(new EncoderHttpMessageWriter<CharSequence>(CharSequenceEncoder.textPlainOnly()));
        if (!forMultipart) {
            this.extendTypedWriters(writers);
        }
        return writers;
    }

    protected void extendTypedWriters(List<HttpMessageWriter<?>> typedWriters) {
    }

    final List<HttpMessageWriter<?>> getObjectWriters(boolean forMultipart) {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList writers = new ArrayList();
        if (jackson2Present) {
            writers.add(new EncoderHttpMessageWriter(this.getJackson2JsonEncoder()));
        }
        if (jackson2SmilePresent) {
            writers.add(new EncoderHttpMessageWriter<Object>(new Jackson2SmileEncoder()));
        }
        if (jaxb2Present) {
            writers.add(new EncoderHttpMessageWriter<Object>(new Jaxb2XmlEncoder()));
        }
        if (!forMultipart) {
            this.extendObjectWriters(writers);
        }
        return writers;
    }

    protected void extendObjectWriters(List<HttpMessageWriter<?>> objectWriters) {
    }

    List<HttpMessageWriter<?>> getCatchAllWriters() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        result.add(new EncoderHttpMessageWriter<CharSequence>(CharSequenceEncoder.allMimeTypes()));
        return result;
    }

    protected Decoder<?> getJackson2JsonDecoder() {
        return this.jackson2JsonDecoder != null ? this.jackson2JsonDecoder : new Jackson2JsonDecoder();
    }

    protected Encoder<?> getJackson2JsonEncoder() {
        return this.jackson2JsonEncoder != null ? this.jackson2JsonEncoder : new Jackson2JsonEncoder();
    }
}

