/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.codec.support;

import com.baidu.cloud.thirdparty.springframework.core.codec.Encoder;
import com.baidu.cloud.thirdparty.springframework.http.codec.HttpMessageReader;
import com.baidu.cloud.thirdparty.springframework.http.codec.HttpMessageWriter;
import com.baidu.cloud.thirdparty.springframework.http.codec.ServerCodecConfigurer;
import com.baidu.cloud.thirdparty.springframework.http.codec.ServerSentEventHttpMessageWriter;
import com.baidu.cloud.thirdparty.springframework.http.codec.multipart.MultipartHttpMessageReader;
import com.baidu.cloud.thirdparty.springframework.http.codec.multipart.SynchronossPartHttpMessageReader;
import com.baidu.cloud.thirdparty.springframework.http.codec.support.BaseDefaultCodecs;
import com.baidu.cloud.thirdparty.springframework.http.codec.support.DefaultServerCodecConfigurer;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import java.util.List;

class ServerDefaultCodecsImpl
extends BaseDefaultCodecs
implements ServerCodecConfigurer.ServerDefaultCodecs {
    private static final boolean synchronossMultipartPresent = ClassUtils.isPresent("org.synchronoss.cloud.nio.multipart.NioMultipartParser", DefaultServerCodecConfigurer.class.getClassLoader());
    @Nullable
    private Encoder<?> sseEncoder;

    ServerDefaultCodecsImpl() {
    }

    @Override
    public void serverSentEventEncoder(Encoder<?> encoder) {
        this.sseEncoder = encoder;
    }

    @Override
    protected void extendTypedReaders(List<HttpMessageReader<?>> typedReaders) {
        if (synchronossMultipartPresent) {
            SynchronossPartHttpMessageReader partReader = new SynchronossPartHttpMessageReader();
            typedReaders.add(partReader);
            typedReaders.add(new MultipartHttpMessageReader(partReader));
        }
    }

    @Override
    protected void extendObjectWriters(List<HttpMessageWriter<?>> objectWriters) {
        objectWriters.add(new ServerSentEventHttpMessageWriter(this.getSseEncoder()));
    }

    @Nullable
    private Encoder<?> getSseEncoder() {
        return this.sseEncoder != null ? this.sseEncoder : (jackson2Present ? this.getJackson2JsonEncoder() : null);
    }
}

