/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.server;

import com.baidu.cloud.thirdparty.servlet.AsyncContext;
import com.baidu.cloud.thirdparty.servlet.AsyncEvent;
import com.baidu.cloud.thirdparty.servlet.AsyncListener;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.http.server.ServerHttpAsyncRequestControl;
import com.baidu.cloud.thirdparty.springframework.http.server.ServletServerHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.server.ServletServerHttpResponse;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServletServerHttpAsyncRequestControl
implements ServerHttpAsyncRequestControl,
AsyncListener {
    private static final long NO_TIMEOUT_VALUE = Long.MIN_VALUE;
    private final ServletServerHttpRequest request;
    private final ServletServerHttpResponse response;
    @Nullable
    private AsyncContext asyncContext;
    private AtomicBoolean asyncCompleted = new AtomicBoolean(false);

    public ServletServerHttpAsyncRequestControl(ServletServerHttpRequest request, ServletServerHttpResponse response) {
        Assert.notNull((Object)request, "request is required");
        Assert.notNull((Object)response, "response is required");
        Assert.isTrue(request.getServletRequest().isAsyncSupported(), "Async support must be enabled on a servlet and for all filters involved in async request processing. This is done in Java code using the Servlet API or by adding \"<async-supported>true</async-supported>\" to servlet and filter declarations in web.xml. Also you must use a Servlet 3.0+ container");
        this.request = request;
        this.response = response;
    }

    @Override
    public boolean isStarted() {
        return this.asyncContext != null && this.request.getServletRequest().isAsyncStarted();
    }

    @Override
    public boolean isCompleted() {
        return this.asyncCompleted.get();
    }

    @Override
    public void start() {
        this.start(Long.MIN_VALUE);
    }

    @Override
    public void start(long timeout) {
        Assert.state(!this.isCompleted(), "Async processing has already completed");
        if (this.isStarted()) {
            return;
        }
        HttpServletRequest servletRequest = this.request.getServletRequest();
        HttpServletResponse servletResponse = this.response.getServletResponse();
        this.asyncContext = servletRequest.startAsync(servletRequest, servletResponse);
        this.asyncContext.addListener(this);
        if (timeout != Long.MIN_VALUE) {
            this.asyncContext.setTimeout(timeout);
        }
    }

    @Override
    public void complete() {
        if (this.asyncContext != null && this.isStarted() && !this.isCompleted()) {
            this.asyncContext.complete();
        }
    }

    @Override
    public void onComplete(AsyncEvent event) throws IOException {
        this.asyncContext = null;
        this.asyncCompleted.set(true);
    }

    @Override
    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    @Override
    public void onError(AsyncEvent event) throws IOException {
    }

    @Override
    public void onTimeout(AsyncEvent event) throws IOException {
    }
}

