/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.instrument.classloading.weblogic;

import com.baidu.cloud.thirdparty.springframework.core.OverridingClassLoader;
import com.baidu.cloud.thirdparty.springframework.instrument.classloading.LoadTimeWeaver;
import com.baidu.cloud.thirdparty.springframework.instrument.classloading.weblogic.WebLogicClassLoaderAdapter;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import java.lang.instrument.ClassFileTransformer;

public class WebLogicLoadTimeWeaver
implements LoadTimeWeaver {
    private final WebLogicClassLoaderAdapter classLoader;

    public WebLogicLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public WebLogicLoadTimeWeaver(@Nullable ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, "ClassLoader must not be null");
        this.classLoader = new WebLogicClassLoaderAdapter(classLoader);
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader.getClassLoader();
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new OverridingClassLoader(this.classLoader.getClassLoader(), this.classLoader.getThrowawayClassLoader());
    }
}

