/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.jmx.access;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.jmx.MBeanServerNotFoundException;
import com.baidu.cloud.thirdparty.springframework.jmx.support.JmxUtils;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import java.io.IOException;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

class ConnectorDelegate {
    private static final Log logger = LogFactory.getLog(ConnectorDelegate.class);
    @Nullable
    private JMXConnector connector;

    ConnectorDelegate() {
    }

    public MBeanServerConnection connect(@Nullable JMXServiceURL serviceUrl, @Nullable Map<String, ?> environment2, @Nullable String agentId) throws MBeanServerNotFoundException {
        if (serviceUrl != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Connecting to remote MBeanServer at URL [" + serviceUrl + "]");
            }
            try {
                this.connector = JMXConnectorFactory.connect(serviceUrl, environment2);
                return this.connector.getMBeanServerConnection();
            }
            catch (IOException ex) {
                throw new MBeanServerNotFoundException("Could not connect to remote MBeanServer [" + serviceUrl + "]", ex);
            }
        }
        logger.debug("Attempting to locate local MBeanServer");
        return JmxUtils.locateMBeanServer(agentId);
    }

    public void close() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException ex) {
                logger.debug("Could not close JMX connector", ex);
            }
        }
    }
}

