/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.scheduling.config;

import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanDefinition;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanDefinitionHolder;
import com.baidu.cloud.thirdparty.springframework.beans.factory.parsing.BeanComponentDefinition;
import com.baidu.cloud.thirdparty.springframework.beans.factory.parsing.CompositeComponentDefinition;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.BeanDefinitionBuilder;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.baidu.cloud.thirdparty.springframework.beans.factory.xml.BeanDefinitionParser;
import com.baidu.cloud.thirdparty.springframework.beans.factory.xml.ParserContext;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ASYNC_EXECUTION_ASPECT_CLASS_NAME = "com.baidu.cloud.thirdparty.springframework.scheduling.aspectj.AnnotationAsyncExecutionAspect";

    @Override
    @Nullable
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder;
        Object source = parserContext.extractSource(element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserContext.pushContainingComponent(compDefinition);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        String mode = element.getAttribute("mode");
        if ("aspectj".equals(mode)) {
            this.registerAsyncExecutionAspect(element, parserContext);
        } else if (registry.containsBeanDefinition("com.baidu.cloud.thirdparty.springframework.context.annotation.internalAsyncAnnotationProcessor")) {
            parserContext.getReaderContext().error("Only one AsyncAnnotationBeanPostProcessor may exist within the context.", source);
        } else {
            String exceptionHandler;
            builder = BeanDefinitionBuilder.genericBeanDefinition("com.baidu.cloud.thirdparty.springframework.scheduling.annotation.AsyncAnnotationBeanPostProcessor");
            builder.getRawBeanDefinition().setSource(source);
            String executor = element.getAttribute("executor");
            if (StringUtils.hasText(executor)) {
                builder.addPropertyReference("executor", executor);
            }
            if (StringUtils.hasText(exceptionHandler = element.getAttribute("exception-handler"))) {
                builder.addPropertyReference("exceptionHandler", exceptionHandler);
            }
            if (Boolean.valueOf(element.getAttribute("proxy-target-class")).booleanValue()) {
                builder.addPropertyValue("proxyTargetClass", true);
            }
            AnnotationDrivenBeanDefinitionParser.registerPostProcessor(parserContext, builder, "com.baidu.cloud.thirdparty.springframework.context.annotation.internalAsyncAnnotationProcessor");
        }
        if (registry.containsBeanDefinition("com.baidu.cloud.thirdparty.springframework.context.annotation.internalScheduledAnnotationProcessor")) {
            parserContext.getReaderContext().error("Only one ScheduledAnnotationBeanPostProcessor may exist within the context.", source);
        } else {
            builder = BeanDefinitionBuilder.genericBeanDefinition("com.baidu.cloud.thirdparty.springframework.scheduling.annotation.ScheduledAnnotationBeanPostProcessor");
            builder.getRawBeanDefinition().setSource(source);
            String scheduler = element.getAttribute("scheduler");
            if (StringUtils.hasText(scheduler)) {
                builder.addPropertyReference("scheduler", scheduler);
            }
            AnnotationDrivenBeanDefinitionParser.registerPostProcessor(parserContext, builder, "com.baidu.cloud.thirdparty.springframework.context.annotation.internalScheduledAnnotationProcessor");
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private void registerAsyncExecutionAspect(Element element, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("com.baidu.cloud.thirdparty.springframework.scheduling.config.internalAsyncExecutionAspect")) {
            String exceptionHandler;
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ASYNC_EXECUTION_ASPECT_CLASS_NAME);
            builder.setFactoryMethod("aspectOf");
            String executor = element.getAttribute("executor");
            if (StringUtils.hasText(executor)) {
                builder.addPropertyReference("executor", executor);
            }
            if (StringUtils.hasText(exceptionHandler = element.getAttribute("exception-handler"))) {
                builder.addPropertyReference("exceptionHandler", exceptionHandler);
            }
            parserContext.registerBeanComponent(new BeanComponentDefinition(builder.getBeanDefinition(), "com.baidu.cloud.thirdparty.springframework.scheduling.config.internalAsyncExecutionAspect"));
        }
    }

    private static void registerPostProcessor(ParserContext parserContext, BeanDefinitionBuilder builder, String beanName) {
        builder.setRole(2);
        parserContext.getRegistry().registerBeanDefinition(beanName, builder.getBeanDefinition());
        BeanDefinitionHolder holder = new BeanDefinitionHolder(builder.getBeanDefinition(), beanName);
        parserContext.registerComponent(new BeanComponentDefinition(holder));
    }
}

