/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.accept;

import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.http.MediaType;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.HttpMediaTypeNotAcceptableException;
import com.baidu.cloud.thirdparty.springframework.web.accept.PathExtensionContentNegotiationStrategy;
import com.baidu.cloud.thirdparty.springframework.web.context.request.NativeWebRequest;
import java.util.Map;

public class ServletPathExtensionContentNegotiationStrategy
extends PathExtensionContentNegotiationStrategy {
    private final ServletContext servletContext;

    public ServletPathExtensionContentNegotiationStrategy(ServletContext context) {
        this(context, null);
    }

    public ServletPathExtensionContentNegotiationStrategy(ServletContext servletContext, @Nullable Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
        Assert.notNull((Object)servletContext, "ServletContext is required");
        this.servletContext = servletContext;
    }

    @Override
    @Nullable
    protected MediaType handleNoMatch(NativeWebRequest webRequest, String extension) throws HttpMediaTypeNotAcceptableException {
        MediaType superMediaType;
        MediaType mediaType = null;
        String mimeType = this.servletContext.getMimeType("file." + extension);
        if (StringUtils.hasText(mimeType)) {
            mediaType = MediaType.parseMediaType(mimeType);
        }
        if ((mediaType == null || MediaType.APPLICATION_OCTET_STREAM.equals(mediaType)) && (superMediaType = super.handleNoMatch(webRequest, extension)) != null) {
            mediaType = superMediaType;
        }
        return mediaType;
    }

    @Override
    public MediaType getMediaTypeForResource(Resource resource) {
        MediaType superMediaType;
        MediaType mediaType = null;
        String mimeType = this.servletContext.getMimeType(resource.getFilename());
        if (StringUtils.hasText(mimeType)) {
            mediaType = MediaType.parseMediaType(mimeType);
        }
        if ((mediaType == null || MediaType.APPLICATION_OCTET_STREAM.equals(mediaType)) && (superMediaType = super.getMediaTypeForResource(resource)) != null) {
            mediaType = superMediaType;
        }
        return mediaType;
    }
}

