/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.context;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.servlet.ServletContextEvent;
import com.baidu.cloud.thirdparty.servlet.ServletContextListener;
import com.baidu.cloud.thirdparty.springframework.beans.factory.DisposableBean;
import java.util.Enumeration;

public class ContextCleanupListener
implements ServletContextListener {
    private static final Log logger = LogFactory.getLog(ContextCleanupListener.class);

    @Override
    public void contextInitialized(ServletContextEvent event) {
    }

    @Override
    public void contextDestroyed(ServletContextEvent event) {
        ContextCleanupListener.cleanupAttributes(event.getServletContext());
    }

    static void cleanupAttributes(ServletContext sc) {
        Enumeration<String> attrNames = sc.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            Object attrValue;
            String attrName = attrNames.nextElement();
            if (!attrName.startsWith("com.baidu.cloud.thirdparty.springframework.") || !((attrValue = sc.getAttribute(attrName)) instanceof DisposableBean)) continue;
            try {
                ((DisposableBean)attrValue).destroy();
            }
            catch (Throwable ex) {
                logger.error("Couldn't invoke destroy method of attribute with name '" + attrName + "'", ex);
            }
        }
    }
}

