/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.context.support;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequestWrapper;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.context.WebApplicationContext;
import java.util.HashSet;
import java.util.Set;

public class ContextExposingHttpServletRequest
extends HttpServletRequestWrapper {
    private final WebApplicationContext webApplicationContext;
    @Nullable
    private final Set<String> exposedContextBeanNames;
    @Nullable
    private Set<String> explicitAttributes;

    public ContextExposingHttpServletRequest(HttpServletRequest originalRequest, WebApplicationContext context) {
        this(originalRequest, context, null);
    }

    public ContextExposingHttpServletRequest(HttpServletRequest originalRequest, WebApplicationContext context, @Nullable Set<String> exposedContextBeanNames) {
        super(originalRequest);
        Assert.notNull((Object)context, "WebApplicationContext must not be null");
        this.webApplicationContext = context;
        this.exposedContextBeanNames = exposedContextBeanNames;
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    @Override
    @Nullable
    public Object getAttribute(String name) {
        if (!(this.explicitAttributes != null && this.explicitAttributes.contains(name) || this.exposedContextBeanNames != null && !this.exposedContextBeanNames.contains(name) || !this.webApplicationContext.containsBean(name))) {
            return this.webApplicationContext.getBean(name);
        }
        return super.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        if (this.explicitAttributes == null) {
            this.explicitAttributes = new HashSet<String>(8);
        }
        this.explicitAttributes.add(name);
    }
}

