/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.cors.reactive;

import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServerHttpRequest;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.cors.CorsConfiguration;
import com.baidu.cloud.thirdparty.springframework.web.cors.reactive.CorsConfigurationSource;
import com.baidu.cloud.thirdparty.springframework.web.cors.reactive.CorsProcessor;
import com.baidu.cloud.thirdparty.springframework.web.cors.reactive.CorsUtils;
import com.baidu.cloud.thirdparty.springframework.web.cors.reactive.DefaultCorsProcessor;
import com.baidu.cloud.thirdparty.springframework.web.server.ServerWebExchange;
import com.baidu.cloud.thirdparty.springframework.web.server.WebFilter;
import com.baidu.cloud.thirdparty.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CorsWebFilter
implements WebFilter {
    private final CorsConfigurationSource configSource;
    private final CorsProcessor processor;

    public CorsWebFilter(CorsConfigurationSource configSource) {
        this(configSource, new DefaultCorsProcessor());
    }

    public CorsWebFilter(CorsConfigurationSource configSource, CorsProcessor processor) {
        Assert.notNull((Object)configSource, "CorsConfigurationSource must not be null");
        Assert.notNull((Object)processor, "CorsProcessor must not be null");
        this.configSource = configSource;
        this.processor = processor;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        boolean isValid;
        CorsConfiguration corsConfiguration;
        ServerHttpRequest request = exchange2.getRequest();
        if (CorsUtils.isCorsRequest(request) && (corsConfiguration = this.configSource.getCorsConfiguration(exchange2)) != null && (!(isValid = this.processor.process(corsConfiguration, exchange2)) || CorsUtils.isPreFlightRequest(request))) {
            return Mono.empty();
        }
        return chain.filter(exchange2);
    }
}

