/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.cors.reactive;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.http.HttpHeaders;
import com.baidu.cloud.thirdparty.springframework.http.HttpMethod;
import com.baidu.cloud.thirdparty.springframework.http.HttpStatus;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServerHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServerHttpResponse;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.web.cors.CorsConfiguration;
import com.baidu.cloud.thirdparty.springframework.web.cors.reactive.CorsProcessor;
import com.baidu.cloud.thirdparty.springframework.web.cors.reactive.CorsUtils;
import com.baidu.cloud.thirdparty.springframework.web.server.ServerWebExchange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultCorsProcessor
implements CorsProcessor {
    private static final Log logger = LogFactory.getLog(DefaultCorsProcessor.class);

    @Override
    public boolean process(@Nullable CorsConfiguration config, ServerWebExchange exchange2) {
        ServerHttpRequest request = exchange2.getRequest();
        ServerHttpResponse response = exchange2.getResponse();
        if (!CorsUtils.isCorsRequest(request)) {
            return true;
        }
        if (this.responseHasCors(response)) {
            logger.debug("Skip CORS: response already contains \"Access-Control-Allow-Origin\" header");
            return true;
        }
        if (CorsUtils.isSameOrigin(request)) {
            logger.debug("Skip CORS: request is from same origin");
            return true;
        }
        boolean preFlightRequest = CorsUtils.isPreFlightRequest(request);
        if (config == null) {
            if (preFlightRequest) {
                this.rejectRequest(response);
                return false;
            }
            return true;
        }
        return this.handleInternal(exchange2, config, preFlightRequest);
    }

    private boolean responseHasCors(ServerHttpResponse response) {
        return response.getHeaders().getAccessControlAllowOrigin() != null;
    }

    protected void rejectRequest(ServerHttpResponse response) {
        response.setStatusCode(HttpStatus.FORBIDDEN);
        logger.debug("Invalid CORS request");
    }

    protected boolean handleInternal(ServerWebExchange exchange2, CorsConfiguration config, boolean preFlightRequest) {
        ServerHttpRequest request = exchange2.getRequest();
        ServerHttpResponse response = exchange2.getResponse();
        HttpHeaders responseHeaders = response.getHeaders();
        response.getHeaders().addAll("Vary", Arrays.asList("Origin", "Access-Control-Request-Method", "Access-Control-Request-Headers"));
        String requestOrigin = request.getHeaders().getOrigin();
        String allowOrigin = this.checkOrigin(config, requestOrigin);
        if (allowOrigin == null) {
            logger.debug("Rejecting CORS request because '" + requestOrigin + "' origin is not allowed");
            this.rejectRequest(response);
            return false;
        }
        HttpMethod requestMethod = this.getMethodToUse(request, preFlightRequest);
        List<HttpMethod> allowMethods = this.checkMethods(config, requestMethod);
        if (allowMethods == null) {
            logger.debug("Rejecting CORS request because '" + (Object)((Object)requestMethod) + "' request method is not allowed");
            this.rejectRequest(response);
            return false;
        }
        List<String> requestHeaders = this.getHeadersToUse(request, preFlightRequest);
        List<String> allowHeaders = this.checkHeaders(config, requestHeaders);
        if (preFlightRequest && allowHeaders == null) {
            logger.debug("Rejecting CORS request because '" + requestHeaders + "' request headers are not allowed");
            this.rejectRequest(response);
            return false;
        }
        responseHeaders.setAccessControlAllowOrigin(allowOrigin);
        if (preFlightRequest) {
            responseHeaders.setAccessControlAllowMethods(allowMethods);
        }
        if (preFlightRequest && !allowHeaders.isEmpty()) {
            responseHeaders.setAccessControlAllowHeaders(allowHeaders);
        }
        if (!CollectionUtils.isEmpty(config.getExposedHeaders())) {
            responseHeaders.setAccessControlExposeHeaders(config.getExposedHeaders());
        }
        if (Boolean.TRUE.equals(config.getAllowCredentials())) {
            responseHeaders.setAccessControlAllowCredentials(true);
        }
        if (preFlightRequest && config.getMaxAge() != null) {
            responseHeaders.setAccessControlMaxAge(config.getMaxAge());
        }
        return true;
    }

    @Nullable
    protected String checkOrigin(CorsConfiguration config, @Nullable String requestOrigin) {
        return config.checkOrigin(requestOrigin);
    }

    @Nullable
    protected List<HttpMethod> checkMethods(CorsConfiguration config, @Nullable HttpMethod requestMethod) {
        return config.checkHttpMethod(requestMethod);
    }

    @Nullable
    private HttpMethod getMethodToUse(ServerHttpRequest request, boolean isPreFlight) {
        return isPreFlight ? request.getHeaders().getAccessControlRequestMethod() : request.getMethod();
    }

    @Nullable
    protected List<String> checkHeaders(CorsConfiguration config, List<String> requestHeaders) {
        return config.checkHeaders(requestHeaders);
    }

    private List<String> getHeadersToUse(ServerHttpRequest request, boolean isPreFlight) {
        HttpHeaders headers = request.getHeaders();
        return isPreFlight ? headers.getAccessControlRequestHeaders() : new ArrayList<String>(headers.keySet());
    }
}

