/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.filter;

import com.baidu.cloud.thirdparty.servlet.FilterChain;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.http.HttpStatus;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.filter.OncePerRequestFilter;
import com.baidu.cloud.thirdparty.springframework.web.filter.RelativeRedirectResponseWrapper;
import java.io.IOException;

public class RelativeRedirectFilter
extends OncePerRequestFilter {
    private HttpStatus redirectStatus = HttpStatus.SEE_OTHER;

    public void setRedirectStatus(HttpStatus status) {
        Assert.notNull((Object)status, "Property 'redirectStatus' is required");
        Assert.isTrue(status.is3xxRedirection(), "Not a redirect status code");
        this.redirectStatus = status;
    }

    public HttpStatus getRedirectStatus() {
        return this.redirectStatus;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        response = RelativeRedirectResponseWrapper.wrapIfNecessary(response, this.redirectStatus);
        filterChain.doFilter(request, response);
    }
}

