/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.method.annotation;

import com.baidu.cloud.thirdparty.springframework.core.MethodParameter;
import com.baidu.cloud.thirdparty.springframework.http.HttpHeaders;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.LinkedMultiValueMap;
import com.baidu.cloud.thirdparty.springframework.util.MultiValueMap;
import com.baidu.cloud.thirdparty.springframework.web.bind.annotation.RequestHeader;
import com.baidu.cloud.thirdparty.springframework.web.bind.support.WebDataBinderFactory;
import com.baidu.cloud.thirdparty.springframework.web.context.request.NativeWebRequest;
import com.baidu.cloud.thirdparty.springframework.web.method.support.HandlerMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.support.ModelAndViewContainer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class RequestHeaderMapMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestHeader.class) && Map.class.isAssignableFrom(parameter.getParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        Class<?> paramType = parameter.getParameterType();
        if (MultiValueMap.class.isAssignableFrom(paramType)) {
            MultiValueMap<String, String> result = HttpHeaders.class.isAssignableFrom(paramType) ? new HttpHeaders() : new LinkedMultiValueMap();
            Iterator<String> iterator = webRequest.getHeaderNames();
            while (iterator.hasNext()) {
                String headerName = iterator.next();
                String[] headerValues = webRequest.getHeaderValues(headerName);
                if (headerValues == null) continue;
                for (String headerValue : headerValues) {
                    result.add(headerName, headerValue);
                }
            }
            return result;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Iterator<String> iterator = webRequest.getHeaderNames();
        while (iterator.hasNext()) {
            String headerName = iterator.next();
            String headerValue = webRequest.getHeader(headerName);
            if (headerValue == null) continue;
            result.put(headerName, headerValue);
        }
        return result;
    }
}

