/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.multipart.commons;

import com.baidu.cloud.thirdparty.apache.commons.fileupload.FileItemFactory;
import com.baidu.cloud.thirdparty.apache.commons.fileupload.FileUpload;
import com.baidu.cloud.thirdparty.apache.commons.fileupload.FileUploadBase;
import com.baidu.cloud.thirdparty.apache.commons.fileupload.FileUploadException;
import com.baidu.cloud.thirdparty.apache.commons.fileupload.servlet.ServletFileUpload;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.context.ServletContextAware;
import com.baidu.cloud.thirdparty.springframework.web.multipart.MaxUploadSizeExceededException;
import com.baidu.cloud.thirdparty.springframework.web.multipart.MultipartException;
import com.baidu.cloud.thirdparty.springframework.web.multipart.MultipartHttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.web.multipart.MultipartResolver;
import com.baidu.cloud.thirdparty.springframework.web.multipart.commons.CommonsFileUploadSupport;
import com.baidu.cloud.thirdparty.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.web.util.WebUtils;
import java.util.List;

public class CommonsMultipartResolver
extends CommonsFileUploadSupport
implements MultipartResolver,
ServletContextAware {
    private boolean resolveLazily = false;

    public CommonsMultipartResolver() {
    }

    public CommonsMultipartResolver(ServletContext servletContext) {
        this();
        this.setServletContext(servletContext);
    }

    public void setResolveLazily(boolean resolveLazily) {
        this.resolveLazily = resolveLazily;
    }

    @Override
    protected FileUpload newFileUpload(FileItemFactory fileItemFactory) {
        return new ServletFileUpload(fileItemFactory);
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        if (!this.isUploadTempDirSpecified()) {
            this.getFileItemFactory().setRepository(WebUtils.getTempDir(servletContext));
        }
    }

    @Override
    public boolean isMultipart(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    @Override
    public MultipartHttpServletRequest resolveMultipart(final HttpServletRequest request) throws MultipartException {
        Assert.notNull((Object)request, "Request must not be null");
        if (this.resolveLazily) {
            return new DefaultMultipartHttpServletRequest(request){

                @Override
                protected void initializeMultipart() {
                    CommonsFileUploadSupport.MultipartParsingResult parsingResult = CommonsMultipartResolver.this.parseRequest(request);
                    this.setMultipartFiles(parsingResult.getMultipartFiles());
                    this.setMultipartParameters(parsingResult.getMultipartParameters());
                    this.setMultipartParameterContentTypes(parsingResult.getMultipartParameterContentTypes());
                }
            };
        }
        CommonsFileUploadSupport.MultipartParsingResult parsingResult = this.parseRequest(request);
        return new DefaultMultipartHttpServletRequest(request, parsingResult.getMultipartFiles(), parsingResult.getMultipartParameters(), parsingResult.getMultipartParameterContentTypes());
    }

    protected CommonsFileUploadSupport.MultipartParsingResult parseRequest(HttpServletRequest request) throws MultipartException {
        String encoding = this.determineEncoding(request);
        FileUpload fileUpload = this.prepareFileUpload(encoding);
        try {
            List fileItems = ((ServletFileUpload)fileUpload).parseRequest(request);
            return this.parseFileItems(fileItems, encoding);
        }
        catch (FileUploadBase.SizeLimitExceededException ex) {
            throw new MaxUploadSizeExceededException(fileUpload.getSizeMax(), (Throwable)ex);
        }
        catch (FileUploadBase.FileSizeLimitExceededException ex) {
            throw new MaxUploadSizeExceededException(fileUpload.getFileSizeMax(), (Throwable)ex);
        }
        catch (FileUploadException ex) {
            throw new MultipartException("Failed to parse multipart servlet request", ex);
        }
    }

    protected String determineEncoding(HttpServletRequest request) {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        return encoding;
    }

    @Override
    public void cleanupMultipart(MultipartHttpServletRequest request) {
        if (!(request instanceof AbstractMultipartHttpServletRequest) || ((AbstractMultipartHttpServletRequest)request).isResolved()) {
            try {
                this.cleanupFileItems(request.getMultiFileMap());
            }
            catch (Throwable ex) {
                this.logger.warn("Failed to perform multipart cleanup for servlet request", ex);
            }
        }
    }
}

