/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.server;

import com.baidu.cloud.thirdparty.springframework.context.ApplicationContext;
import com.baidu.cloud.thirdparty.springframework.context.i18n.LocaleContext;
import com.baidu.cloud.thirdparty.springframework.http.codec.multipart.Part;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServerHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServerHttpResponse;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.MultiValueMap;
import com.baidu.cloud.thirdparty.springframework.web.server.DefaultServerWebExchangeBuilder;
import com.baidu.cloud.thirdparty.springframework.web.server.WebSession;
import java.security.Principal;
import java.time.Instant;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public interface ServerWebExchange {
    public ServerHttpRequest getRequest();

    public ServerHttpResponse getResponse();

    public Map<String, Object> getAttributes();

    @Nullable
    default public <T> T getAttribute(String name) {
        return (T)this.getAttributes().get(name);
    }

    default public <T> T getRequiredAttribute(String name) {
        T value = this.getAttribute(name);
        Assert.notNull(value, () -> "Required attribute '" + name + "' is missing");
        return value;
    }

    default public <T> T getAttributeOrDefault(String name, T defaultValue) {
        return (T)this.getAttributes().getOrDefault(name, defaultValue);
    }

    public Mono<WebSession> getSession();

    public <T extends Principal> Mono<T> getPrincipal();

    public Mono<MultiValueMap<String, String>> getFormData();

    public Mono<MultiValueMap<String, Part>> getMultipartData();

    public LocaleContext getLocaleContext();

    @Nullable
    public ApplicationContext getApplicationContext();

    public boolean isNotModified();

    public boolean checkNotModified(Instant var1);

    public boolean checkNotModified(String var1);

    public boolean checkNotModified(@Nullable String var1, Instant var2);

    public String transformUrl(String var1);

    public void addUrlTransformer(Function<String, String> var1);

    default public Builder mutate() {
        return new DefaultServerWebExchangeBuilder(this);
    }

    public static interface Builder {
        public Builder request(Consumer<ServerHttpRequest.Builder> var1);

        public Builder request(ServerHttpRequest var1);

        public Builder response(ServerHttpResponse var1);

        public Builder principal(Mono<Principal> var1);

        public ServerWebExchange build();
    }
}

