/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.server.adapter;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationContext;
import com.baidu.cloud.thirdparty.springframework.core.NestedExceptionUtils;
import com.baidu.cloud.thirdparty.springframework.http.HttpStatus;
import com.baidu.cloud.thirdparty.springframework.http.codec.ServerCodecConfigurer;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.HttpHandler;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServerHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServerHttpResponse;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.server.ServerWebExchange;
import com.baidu.cloud.thirdparty.springframework.web.server.WebHandler;
import com.baidu.cloud.thirdparty.springframework.web.server.adapter.DefaultServerWebExchange;
import com.baidu.cloud.thirdparty.springframework.web.server.handler.WebHandlerDecorator;
import com.baidu.cloud.thirdparty.springframework.web.server.i18n.AcceptHeaderLocaleContextResolver;
import com.baidu.cloud.thirdparty.springframework.web.server.i18n.LocaleContextResolver;
import com.baidu.cloud.thirdparty.springframework.web.server.session.DefaultWebSessionManager;
import com.baidu.cloud.thirdparty.springframework.web.server.session.WebSessionManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import reactor.core.publisher.Mono;

public class HttpWebHandlerAdapter
extends WebHandlerDecorator
implements HttpHandler {
    private static final String DISCONNECTED_CLIENT_LOG_CATEGORY = "com.baidu.cloud.thirdparty.springframework.web.server.DisconnectedClient";
    private static final Set<String> DISCONNECTED_CLIENT_EXCEPTIONS = new HashSet<String>(Arrays.asList("ClientAbortException", "EOFException", "EofException"));
    private static final Log logger = LogFactory.getLog(HttpWebHandlerAdapter.class);
    private static final Log disconnectedClientLogger = LogFactory.getLog("com.baidu.cloud.thirdparty.springframework.web.server.DisconnectedClient");
    private WebSessionManager sessionManager = new DefaultWebSessionManager();
    @Nullable
    private ServerCodecConfigurer codecConfigurer;
    @Nullable
    private LocaleContextResolver localeContextResolver;
    @Nullable
    private ApplicationContext applicationContext;

    public HttpWebHandlerAdapter(WebHandler delegate) {
        super(delegate);
    }

    public void setSessionManager(WebSessionManager sessionManager) {
        Assert.notNull((Object)sessionManager, "WebSessionManager must not be null");
        this.sessionManager = sessionManager;
    }

    public WebSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setCodecConfigurer(ServerCodecConfigurer codecConfigurer) {
        Assert.notNull((Object)codecConfigurer, "ServerCodecConfigurer must not be null");
        this.codecConfigurer = codecConfigurer;
    }

    public ServerCodecConfigurer getCodecConfigurer() {
        return this.codecConfigurer != null ? this.codecConfigurer : ServerCodecConfigurer.create();
    }

    public void setLocaleContextResolver(LocaleContextResolver localeContextResolver) {
        this.localeContextResolver = localeContextResolver;
    }

    public LocaleContextResolver getLocaleContextResolver() {
        return this.localeContextResolver != null ? this.localeContextResolver : new AcceptHeaderLocaleContextResolver();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Nullable
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
        ServerWebExchange exchange2 = this.createExchange(request, response);
        return this.getDelegate().handle(exchange2).onErrorResume(ex -> this.handleFailure(request, response, (Throwable)ex)).then(Mono.defer(response::setComplete));
    }

    protected ServerWebExchange createExchange(ServerHttpRequest request, ServerHttpResponse response) {
        return new DefaultServerWebExchange(request, response, this.sessionManager, this.getCodecConfigurer(), this.getLocaleContextResolver(), this.applicationContext);
    }

    private Mono<Void> handleFailure(ServerHttpRequest request, ServerHttpResponse response, Throwable ex) {
        if (this.isDisconnectedClientError(ex)) {
            if (disconnectedClientLogger.isTraceEnabled()) {
                disconnectedClientLogger.trace("Looks like the client has gone away", ex);
            } else if (disconnectedClientLogger.isDebugEnabled()) {
                disconnectedClientLogger.debug("Looks like the client has gone away: " + ex + " (For a full stack trace, set the log category '" + DISCONNECTED_CLIENT_LOG_CATEGORY + "' to TRACE level.)");
            }
            return Mono.empty();
        }
        if (response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR)) {
            logger.error("Failed to handle request [" + (Object)((Object)request.getMethod()) + " " + request.getURI() + "]", ex);
            return Mono.empty();
        }
        HttpStatus status = response.getStatusCode();
        logger.error("Unhandled failure: " + ex.getMessage() + ", response already set (status=" + (Object)((Object)status) + ")");
        return Mono.error((Throwable)ex);
    }

    private boolean isDisconnectedClientError(Throwable ex) {
        String message = NestedExceptionUtils.getMostSpecificCause(ex).getMessage();
        message = message != null ? message.toLowerCase() : "";
        String className = ex.getClass().getSimpleName();
        return message.contains("broken pipe") || DISCONNECTED_CLIENT_EXCEPTIONS.contains(className);
    }
}

