/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.config;

import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanDefinition;
import com.baidu.cloud.thirdparty.springframework.beans.factory.parsing.BeanComponentDefinition;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.ManagedMap;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.RootBeanDefinition;
import com.baidu.cloud.thirdparty.springframework.beans.factory.xml.BeanDefinitionParser;
import com.baidu.cloud.thirdparty.springframework.beans.factory.xml.ParserContext;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.config.MvcNamespaceUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.DefaultServletHttpRequestHandler;
import org.w3c.dom.Element;

class DefaultServletHandlerBeanDefinitionParser
implements BeanDefinitionParser {
    DefaultServletHandlerBeanDefinitionParser() {
    }

    @Override
    @Nullable
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource(element);
        String defaultServletName = element.getAttribute("default-servlet-name");
        RootBeanDefinition defaultServletHandlerDef = new RootBeanDefinition(DefaultServletHttpRequestHandler.class);
        defaultServletHandlerDef.setSource(source);
        defaultServletHandlerDef.setRole(2);
        if (StringUtils.hasText(defaultServletName)) {
            defaultServletHandlerDef.getPropertyValues().add("defaultServletName", defaultServletName);
        }
        String defaultServletHandlerName = parserContext.getReaderContext().generateBeanName(defaultServletHandlerDef);
        parserContext.getRegistry().registerBeanDefinition(defaultServletHandlerName, defaultServletHandlerDef);
        parserContext.registerComponent(new BeanComponentDefinition(defaultServletHandlerDef, defaultServletHandlerName));
        ManagedMap<String, String> urlMap = new ManagedMap<String, String>();
        urlMap.put("/**", defaultServletHandlerName);
        RootBeanDefinition handlerMappingDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        handlerMappingDef.setSource(source);
        handlerMappingDef.setRole(2);
        handlerMappingDef.getPropertyValues().add("urlMap", urlMap);
        String handlerMappingBeanName = parserContext.getReaderContext().generateBeanName(handlerMappingDef);
        parserContext.getRegistry().registerBeanDefinition(handlerMappingBeanName, handlerMappingDef);
        parserContext.registerComponent(new BeanComponentDefinition(handlerMappingDef, handlerMappingBeanName));
        MvcNamespaceUtils.registerDefaultComponents(parserContext, source);
        return null;
    }
}

