/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation;

import com.baidu.cloud.thirdparty.jackson.databind.ObjectMapper;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.beans.BeanUtils;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanFactoryUtils;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanInitializationException;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationContext;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationContextAware;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Bean;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Lazy;
import com.baidu.cloud.thirdparty.springframework.format.FormatterRegistry;
import com.baidu.cloud.thirdparty.springframework.format.support.DefaultFormattingConversionService;
import com.baidu.cloud.thirdparty.springframework.format.support.FormattingConversionService;
import com.baidu.cloud.thirdparty.springframework.http.MediaType;
import com.baidu.cloud.thirdparty.springframework.http.converter.ByteArrayHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.HttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.ResourceHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.ResourceRegionHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.StringHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.json.GsonHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import com.baidu.cloud.thirdparty.springframework.http.converter.json.JsonbHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.http.converter.xml.SourceHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.AntPathMatcher;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import com.baidu.cloud.thirdparty.springframework.util.PathMatcher;
import com.baidu.cloud.thirdparty.springframework.validation.Errors;
import com.baidu.cloud.thirdparty.springframework.validation.MessageCodesResolver;
import com.baidu.cloud.thirdparty.springframework.validation.Validator;
import com.baidu.cloud.thirdparty.springframework.web.accept.ContentNegotiationManager;
import com.baidu.cloud.thirdparty.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import com.baidu.cloud.thirdparty.springframework.web.context.ServletContextAware;
import com.baidu.cloud.thirdparty.springframework.web.cors.CorsConfiguration;
import com.baidu.cloud.thirdparty.springframework.web.method.support.CompositeUriComponentsContributor;
import com.baidu.cloud.thirdparty.springframework.web.method.support.HandlerMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.support.HandlerMethodReturnValueHandler;
import com.baidu.cloud.thirdparty.springframework.web.servlet.HandlerExceptionResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.HandlerMapping;
import com.baidu.cloud.thirdparty.springframework.web.servlet.ViewResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation.CorsRegistry;
import com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation.InterceptorRegistry;
import com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.AbstractHandlerMapping;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.ConversionServiceExposingInterceptor;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.HandlerExceptionResolverComposite;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.HandlerMappingIntrospector;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.annotation.ResponseStatusExceptionResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.JsonViewRequestBodyAdvice;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.JsonViewResponseBodyAdvice;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceUrlProvider;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceUrlProviderExposingInterceptor;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.InternalResourceViewResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.ViewResolverComposite;
import com.baidu.cloud.thirdparty.springframework.web.util.UrlPathHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebMvcConfigurationSupport
implements ApplicationContextAware,
ServletContextAware {
    private static final boolean romePresent = ClassUtils.isPresent("com.rometools.rome.feed.WireFeed", WebMvcConfigurationSupport.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent("javax.xml.bind.Binder", WebMvcConfigurationSupport.class.getClassLoader());
    private static final boolean jackson2Present = ClassUtils.isPresent("com.baidu.cloud.thirdparty.jackson.databind.ObjectMapper", WebMvcConfigurationSupport.class.getClassLoader()) && ClassUtils.isPresent("com.baidu.cloud.thirdparty.jackson.core.JsonGenerator", WebMvcConfigurationSupport.class.getClassLoader());
    private static final boolean jackson2XmlPresent = ClassUtils.isPresent("com.baidu.cloud.thirdparty.jackson.dataformat.xml.XmlMapper", WebMvcConfigurationSupport.class.getClassLoader());
    private static final boolean jackson2SmilePresent = ClassUtils.isPresent("com.baidu.cloud.thirdparty.jackson.dataformat.smile.SmileFactory", WebMvcConfigurationSupport.class.getClassLoader());
    private static final boolean jackson2CborPresent = ClassUtils.isPresent("com.baidu.cloud.thirdparty.jackson.dataformat.cbor.CBORFactory", WebMvcConfigurationSupport.class.getClassLoader());
    private static final boolean gsonPresent = ClassUtils.isPresent("com.google.gson.Gson", WebMvcConfigurationSupport.class.getClassLoader());
    private static final boolean jsonbPresent = ClassUtils.isPresent("javax.json.bind.Jsonb", WebMvcConfigurationSupport.class.getClassLoader());
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private ServletContext servletContext;
    @Nullable
    private List<Object> interceptors;
    @Nullable
    private PathMatchConfigurer pathMatchConfigurer;
    @Nullable
    private ContentNegotiationManager contentNegotiationManager;
    @Nullable
    private List<HandlerMethodArgumentResolver> argumentResolvers;
    @Nullable
    private List<HandlerMethodReturnValueHandler> returnValueHandlers;
    @Nullable
    private List<HttpMessageConverter<?>> messageConverters;
    @Nullable
    private Map<String, CorsConfiguration> corsConfigurations;

    @Override
    public void setApplicationContext(@Nullable ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Nullable
    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void setServletContext(@Nullable ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Nullable
    public final ServletContext getServletContext() {
        return this.servletContext;
    }

    @Bean
    public RequestMappingHandlerMapping requestMappingHandlerMapping() {
        PathMatcher pathMatcher;
        UrlPathHelper pathHelper;
        Boolean useTrailingSlashMatch;
        Boolean useRegisteredSuffixPatternMatch;
        RequestMappingHandlerMapping mapping = this.createRequestMappingHandlerMapping();
        mapping.setOrder(0);
        mapping.setInterceptors(this.getInterceptors());
        mapping.setContentNegotiationManager(this.mvcContentNegotiationManager());
        mapping.setCorsConfigurations(this.getCorsConfigurations());
        PathMatchConfigurer configurer = this.getPathMatchConfigurer();
        Boolean useSuffixPatternMatch = configurer.isUseSuffixPatternMatch();
        if (useSuffixPatternMatch != null) {
            mapping.setUseSuffixPatternMatch(useSuffixPatternMatch);
        }
        if ((useRegisteredSuffixPatternMatch = configurer.isUseRegisteredSuffixPatternMatch()) != null) {
            mapping.setUseRegisteredSuffixPatternMatch(useRegisteredSuffixPatternMatch);
        }
        if ((useTrailingSlashMatch = configurer.isUseTrailingSlashMatch()) != null) {
            mapping.setUseTrailingSlashMatch(useTrailingSlashMatch);
        }
        if ((pathHelper = configurer.getUrlPathHelper()) != null) {
            mapping.setUrlPathHelper(pathHelper);
        }
        if ((pathMatcher = configurer.getPathMatcher()) != null) {
            mapping.setPathMatcher(pathMatcher);
        }
        return mapping;
    }

    protected RequestMappingHandlerMapping createRequestMappingHandlerMapping() {
        return new RequestMappingHandlerMapping();
    }

    protected final Object[] getInterceptors() {
        if (this.interceptors == null) {
            InterceptorRegistry registry = new InterceptorRegistry();
            this.addInterceptors(registry);
            registry.addInterceptor(new ConversionServiceExposingInterceptor(this.mvcConversionService()));
            registry.addInterceptor(new ResourceUrlProviderExposingInterceptor(this.mvcResourceUrlProvider()));
            this.interceptors = registry.getInterceptors();
        }
        return this.interceptors.toArray();
    }

    protected void addInterceptors(InterceptorRegistry registry) {
    }

    protected PathMatchConfigurer getPathMatchConfigurer() {
        if (this.pathMatchConfigurer == null) {
            this.pathMatchConfigurer = new PathMatchConfigurer();
            this.configurePathMatch(this.pathMatchConfigurer);
        }
        return this.pathMatchConfigurer;
    }

    protected void configurePathMatch(PathMatchConfigurer configurer) {
    }

    @Bean
    public PathMatcher mvcPathMatcher() {
        PathMatcher pathMatcher = this.getPathMatchConfigurer().getPathMatcher();
        return pathMatcher != null ? pathMatcher : new AntPathMatcher();
    }

    @Bean
    public UrlPathHelper mvcUrlPathHelper() {
        UrlPathHelper pathHelper = this.getPathMatchConfigurer().getUrlPathHelper();
        return pathHelper != null ? pathHelper : new UrlPathHelper();
    }

    @Bean
    public ContentNegotiationManager mvcContentNegotiationManager() {
        if (this.contentNegotiationManager == null) {
            ContentNegotiationConfigurer configurer = new ContentNegotiationConfigurer(this.servletContext);
            configurer.mediaTypes(this.getDefaultMediaTypes());
            this.configureContentNegotiation(configurer);
            this.contentNegotiationManager = configurer.buildContentNegotiationManager();
        }
        return this.contentNegotiationManager;
    }

    protected Map<String, MediaType> getDefaultMediaTypes() {
        HashMap<String, MediaType> map = new HashMap<String, MediaType>(4);
        if (romePresent) {
            map.put("atom", MediaType.APPLICATION_ATOM_XML);
            map.put("rss", MediaType.APPLICATION_RSS_XML);
        }
        if (jaxb2Present || jackson2XmlPresent) {
            map.put("xml", MediaType.APPLICATION_XML);
        }
        if (jackson2Present || gsonPresent || jsonbPresent) {
            map.put("json", MediaType.APPLICATION_JSON);
        }
        if (jackson2SmilePresent) {
            map.put("smile", MediaType.valueOf("application/x-jackson-smile"));
        }
        if (jackson2CborPresent) {
            map.put("cbor", MediaType.valueOf("application/cbor"));
        }
        return map;
    }

    protected void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
    }

    @Bean
    public HandlerMapping viewControllerHandlerMapping() {
        ViewControllerRegistry registry = new ViewControllerRegistry(this.applicationContext);
        this.addViewControllers(registry);
        SimpleUrlHandlerMapping handlerMapping = registry.buildHandlerMapping();
        handlerMapping = handlerMapping != null ? handlerMapping : new EmptyHandlerMapping();
        handlerMapping.setPathMatcher(this.mvcPathMatcher());
        handlerMapping.setUrlPathHelper(this.mvcUrlPathHelper());
        handlerMapping.setInterceptors(this.getInterceptors());
        handlerMapping.setCorsConfigurations(this.getCorsConfigurations());
        return handlerMapping;
    }

    protected void addViewControllers(ViewControllerRegistry registry) {
    }

    @Bean
    public BeanNameUrlHandlerMapping beanNameHandlerMapping() {
        BeanNameUrlHandlerMapping mapping = new BeanNameUrlHandlerMapping();
        mapping.setOrder(2);
        mapping.setInterceptors(this.getInterceptors());
        mapping.setCorsConfigurations(this.getCorsConfigurations());
        return mapping;
    }

    @Bean
    public HandlerMapping resourceHandlerMapping() {
        Assert.state(this.applicationContext != null, "No ApplicationContext set");
        Assert.state(this.servletContext != null, "No ServletContext set");
        ResourceHandlerRegistry registry = new ResourceHandlerRegistry(this.applicationContext, this.servletContext, this.mvcContentNegotiationManager(), this.mvcUrlPathHelper());
        this.addResourceHandlers(registry);
        AbstractHandlerMapping handlerMapping = registry.getHandlerMapping();
        if (handlerMapping != null) {
            handlerMapping.setPathMatcher(this.mvcPathMatcher());
            handlerMapping.setUrlPathHelper(this.mvcUrlPathHelper());
            handlerMapping.setInterceptors(this.getInterceptors());
            handlerMapping.setCorsConfigurations(this.getCorsConfigurations());
        } else {
            handlerMapping = new EmptyHandlerMapping();
        }
        return handlerMapping;
    }

    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
    }

    @Bean
    public ResourceUrlProvider mvcResourceUrlProvider() {
        PathMatcher pathMatcher;
        ResourceUrlProvider urlProvider = new ResourceUrlProvider();
        UrlPathHelper pathHelper = this.getPathMatchConfigurer().getUrlPathHelper();
        if (pathHelper != null) {
            urlProvider.setUrlPathHelper(pathHelper);
        }
        if ((pathMatcher = this.getPathMatchConfigurer().getPathMatcher()) != null) {
            urlProvider.setPathMatcher(pathMatcher);
        }
        return urlProvider;
    }

    @Bean
    public HandlerMapping defaultServletHandlerMapping() {
        Assert.state(this.servletContext != null, "No ServletContext set");
        DefaultServletHandlerConfigurer configurer = new DefaultServletHandlerConfigurer(this.servletContext);
        this.configureDefaultServletHandling(configurer);
        SimpleUrlHandlerMapping handlerMapping = configurer.buildHandlerMapping();
        return handlerMapping != null ? handlerMapping : new EmptyHandlerMapping();
    }

    protected void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
    }

    @Bean
    public RequestMappingHandlerAdapter requestMappingHandlerAdapter() {
        RequestMappingHandlerAdapter adapter = this.createRequestMappingHandlerAdapter();
        adapter.setContentNegotiationManager(this.mvcContentNegotiationManager());
        adapter.setMessageConverters(this.getMessageConverters());
        adapter.setWebBindingInitializer(this.getConfigurableWebBindingInitializer());
        adapter.setCustomArgumentResolvers(this.getArgumentResolvers());
        adapter.setCustomReturnValueHandlers(this.getReturnValueHandlers());
        if (jackson2Present) {
            adapter.setRequestBodyAdvice(Collections.singletonList(new JsonViewRequestBodyAdvice()));
            adapter.setResponseBodyAdvice(Collections.singletonList(new JsonViewResponseBodyAdvice()));
        }
        AsyncSupportConfigurer configurer = new AsyncSupportConfigurer();
        this.configureAsyncSupport(configurer);
        if (configurer.getTaskExecutor() != null) {
            adapter.setTaskExecutor(configurer.getTaskExecutor());
        }
        if (configurer.getTimeout() != null) {
            adapter.setAsyncRequestTimeout(configurer.getTimeout());
        }
        adapter.setCallableInterceptors(configurer.getCallableInterceptors());
        adapter.setDeferredResultInterceptors(configurer.getDeferredResultInterceptors());
        return adapter;
    }

    protected RequestMappingHandlerAdapter createRequestMappingHandlerAdapter() {
        return new RequestMappingHandlerAdapter();
    }

    protected ConfigurableWebBindingInitializer getConfigurableWebBindingInitializer() {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService(this.mvcConversionService());
        initializer.setValidator(this.mvcValidator());
        MessageCodesResolver messageCodesResolver = this.getMessageCodesResolver();
        if (messageCodesResolver != null) {
            initializer.setMessageCodesResolver(messageCodesResolver);
        }
        return initializer;
    }

    @Nullable
    protected MessageCodesResolver getMessageCodesResolver() {
        return null;
    }

    protected void configureAsyncSupport(AsyncSupportConfigurer configurer) {
    }

    @Bean
    public FormattingConversionService mvcConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        this.addFormatters(conversionService);
        return conversionService;
    }

    protected void addFormatters(FormatterRegistry registry) {
    }

    @Bean
    public Validator mvcValidator() {
        Validator validator = this.getValidator();
        if (validator == null) {
            if (ClassUtils.isPresent("javax.validation.Validator", this.getClass().getClassLoader())) {
                Class<?> clazz;
                try {
                    String className = "com.baidu.cloud.thirdparty.springframework.validation.beanvalidation.OptionalValidatorFactoryBean";
                    clazz = ClassUtils.forName(className, WebMvcConfigurationSupport.class.getClassLoader());
                }
                catch (ClassNotFoundException | LinkageError ex) {
                    throw new BeanInitializationException("Failed to resolve default validator class", ex);
                }
                validator = (Validator)BeanUtils.instantiateClass(clazz);
            } else {
                validator = new NoOpValidator();
            }
        }
        return validator;
    }

    @Nullable
    protected Validator getValidator() {
        return null;
    }

    protected final List<HandlerMethodArgumentResolver> getArgumentResolvers() {
        if (this.argumentResolvers == null) {
            this.argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
            this.addArgumentResolvers(this.argumentResolvers);
        }
        return this.argumentResolvers;
    }

    protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
    }

    protected final List<HandlerMethodReturnValueHandler> getReturnValueHandlers() {
        if (this.returnValueHandlers == null) {
            this.returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
            this.addReturnValueHandlers(this.returnValueHandlers);
        }
        return this.returnValueHandlers;
    }

    protected void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
    }

    protected final List<HttpMessageConverter<?>> getMessageConverters() {
        if (this.messageConverters == null) {
            this.messageConverters = new ArrayList();
            this.configureMessageConverters(this.messageConverters);
            if (this.messageConverters.isEmpty()) {
                this.addDefaultHttpMessageConverters(this.messageConverters);
            }
            this.extendMessageConverters(this.messageConverters);
        }
        return this.messageConverters;
    }

    protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    protected final void addDefaultHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Jackson2ObjectMapperBuilder builder;
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        messageConverters.add(new ByteArrayHttpMessageConverter());
        messageConverters.add(stringHttpMessageConverter);
        messageConverters.add(new ResourceHttpMessageConverter());
        messageConverters.add(new ResourceRegionHttpMessageConverter());
        messageConverters.add(new SourceHttpMessageConverter());
        messageConverters.add(new AllEncompassingFormHttpMessageConverter());
        if (romePresent) {
            messageConverters.add(new AtomFeedHttpMessageConverter());
            messageConverters.add(new RssChannelHttpMessageConverter());
        }
        if (jackson2XmlPresent) {
            builder = Jackson2ObjectMapperBuilder.xml();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add(new MappingJackson2XmlHttpMessageConverter((ObjectMapper)builder.build()));
        } else if (jaxb2Present) {
            messageConverters.add(new Jaxb2RootElementHttpMessageConverter());
        }
        if (jackson2Present) {
            builder = Jackson2ObjectMapperBuilder.json();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add(new MappingJackson2HttpMessageConverter((ObjectMapper)builder.build()));
        } else if (gsonPresent) {
            messageConverters.add(new GsonHttpMessageConverter());
        } else if (jsonbPresent) {
            messageConverters.add(new JsonbHttpMessageConverter());
        }
        if (jackson2SmilePresent) {
            builder = Jackson2ObjectMapperBuilder.smile();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add(new MappingJackson2SmileHttpMessageConverter((ObjectMapper)builder.build()));
        }
        if (jackson2CborPresent) {
            builder = Jackson2ObjectMapperBuilder.cbor();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add(new MappingJackson2CborHttpMessageConverter((ObjectMapper)builder.build()));
        }
    }

    @Bean
    public CompositeUriComponentsContributor mvcUriComponentsContributor() {
        return new CompositeUriComponentsContributor(this.requestMappingHandlerAdapter().getArgumentResolvers(), this.mvcConversionService());
    }

    @Bean
    public HttpRequestHandlerAdapter httpRequestHandlerAdapter() {
        return new HttpRequestHandlerAdapter();
    }

    @Bean
    public SimpleControllerHandlerAdapter simpleControllerHandlerAdapter() {
        return new SimpleControllerHandlerAdapter();
    }

    @Bean
    public HandlerExceptionResolver handlerExceptionResolver() {
        ArrayList<HandlerExceptionResolver> exceptionResolvers = new ArrayList<HandlerExceptionResolver>();
        this.configureHandlerExceptionResolvers(exceptionResolvers);
        if (exceptionResolvers.isEmpty()) {
            this.addDefaultHandlerExceptionResolvers(exceptionResolvers);
        }
        this.extendHandlerExceptionResolvers(exceptionResolvers);
        HandlerExceptionResolverComposite composite = new HandlerExceptionResolverComposite();
        composite.setOrder(0);
        composite.setExceptionResolvers(exceptionResolvers);
        return composite;
    }

    protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
    }

    protected void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
    }

    protected final void addDefaultHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        ExceptionHandlerExceptionResolver exceptionHandlerResolver = this.createExceptionHandlerExceptionResolver();
        exceptionHandlerResolver.setContentNegotiationManager(this.mvcContentNegotiationManager());
        exceptionHandlerResolver.setMessageConverters(this.getMessageConverters());
        exceptionHandlerResolver.setCustomArgumentResolvers(this.getArgumentResolvers());
        exceptionHandlerResolver.setCustomReturnValueHandlers(this.getReturnValueHandlers());
        if (jackson2Present) {
            exceptionHandlerResolver.setResponseBodyAdvice(Collections.singletonList(new JsonViewResponseBodyAdvice()));
        }
        if (this.applicationContext != null) {
            exceptionHandlerResolver.setApplicationContext(this.applicationContext);
        }
        exceptionHandlerResolver.afterPropertiesSet();
        exceptionResolvers.add(exceptionHandlerResolver);
        ResponseStatusExceptionResolver responseStatusResolver = new ResponseStatusExceptionResolver();
        responseStatusResolver.setMessageSource(this.applicationContext);
        exceptionResolvers.add(responseStatusResolver);
        exceptionResolvers.add(new DefaultHandlerExceptionResolver());
    }

    protected ExceptionHandlerExceptionResolver createExceptionHandlerExceptionResolver() {
        return new ExceptionHandlerExceptionResolver();
    }

    @Bean
    public ViewResolver mvcViewResolver() {
        String[] names;
        ViewResolverRegistry registry = new ViewResolverRegistry(this.mvcContentNegotiationManager(), this.applicationContext);
        this.configureViewResolvers(registry);
        if (registry.getViewResolvers().isEmpty() && this.applicationContext != null && (names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this.applicationContext, ViewResolver.class, true, false)).length == 1) {
            registry.getViewResolvers().add(new InternalResourceViewResolver());
        }
        ViewResolverComposite composite = new ViewResolverComposite();
        composite.setOrder(registry.getOrder());
        composite.setViewResolvers(registry.getViewResolvers());
        if (this.applicationContext != null) {
            composite.setApplicationContext(this.applicationContext);
        }
        if (this.servletContext != null) {
            composite.setServletContext(this.servletContext);
        }
        return composite;
    }

    protected void configureViewResolvers(ViewResolverRegistry registry) {
    }

    protected final Map<String, CorsConfiguration> getCorsConfigurations() {
        if (this.corsConfigurations == null) {
            CorsRegistry registry = new CorsRegistry();
            this.addCorsMappings(registry);
            this.corsConfigurations = registry.getCorsConfigurations();
        }
        return this.corsConfigurations;
    }

    protected void addCorsMappings(CorsRegistry registry) {
    }

    @Bean
    @Lazy
    public HandlerMappingIntrospector mvcHandlerMappingIntrospector() {
        return new HandlerMappingIntrospector();
    }

    private static final class NoOpValidator
    implements Validator {
        private NoOpValidator() {
        }

        @Override
        public boolean supports(Class<?> clazz) {
            return false;
        }

        @Override
        public void validate(@Nullable Object target, Errors errors) {
        }
    }

    private static final class EmptyHandlerMapping
    extends AbstractHandlerMapping {
        private EmptyHandlerMapping() {
        }

        @Override
        protected Object getHandlerInternal(HttpServletRequest request) {
            return null;
        }
    }
}

