/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.ObjectUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.AbstractNameValueExpression;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.AbstractRequestCondition;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.condition.NameValueExpression;
import com.baidu.cloud.thirdparty.springframework.web.util.WebUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ParamsRequestCondition
extends AbstractRequestCondition<ParamsRequestCondition> {
    private final Set<ParamExpression> expressions;

    public ParamsRequestCondition(String ... params) {
        this(ParamsRequestCondition.parseExpressions(params));
    }

    private ParamsRequestCondition(Collection<ParamExpression> conditions) {
        this.expressions = Collections.unmodifiableSet(new LinkedHashSet<ParamExpression>(conditions));
    }

    private static Collection<ParamExpression> parseExpressions(String ... params) {
        LinkedHashSet<ParamExpression> expressions = new LinkedHashSet<ParamExpression>();
        for (String param : params) {
            expressions.add(new ParamExpression(param));
        }
        return expressions;
    }

    public Set<NameValueExpression<String>> getExpressions() {
        return new LinkedHashSet<NameValueExpression<String>>(this.expressions);
    }

    @Override
    protected Collection<ParamExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    @Override
    public ParamsRequestCondition combine(ParamsRequestCondition other) {
        LinkedHashSet<ParamExpression> set = new LinkedHashSet<ParamExpression>(this.expressions);
        set.addAll(other.expressions);
        return new ParamsRequestCondition(set);
    }

    @Override
    @Nullable
    public ParamsRequestCondition getMatchingCondition(HttpServletRequest request) {
        for (ParamExpression expression : this.expressions) {
            if (expression.match(request)) continue;
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(ParamsRequestCondition other, HttpServletRequest request) {
        return other.expressions.size() - this.expressions.size();
    }

    static class ParamExpression
    extends AbstractNameValueExpression<String> {
        ParamExpression(String expression) {
            super(expression);
        }

        @Override
        protected boolean isCaseSensitiveName() {
            return true;
        }

        @Override
        protected String parseValue(String valueExpression) {
            return valueExpression;
        }

        @Override
        protected boolean matchName(HttpServletRequest request) {
            return WebUtils.hasSubmitParameter(request, this.name) || request.getParameterMap().containsKey(this.name);
        }

        @Override
        protected boolean matchValue(HttpServletRequest request) {
            return ObjectUtils.nullSafeEquals(this.value, request.getParameter(this.name));
        }
    }
}

