/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation;

import com.baidu.cloud.thirdparty.springframework.core.MethodParameter;
import com.baidu.cloud.thirdparty.springframework.core.ResolvableType;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.LinkedMultiValueMap;
import com.baidu.cloud.thirdparty.springframework.util.MultiValueMap;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.bind.annotation.MatrixVariable;
import com.baidu.cloud.thirdparty.springframework.web.bind.support.WebDataBinderFactory;
import com.baidu.cloud.thirdparty.springframework.web.context.request.NativeWebRequest;
import com.baidu.cloud.thirdparty.springframework.web.method.support.HandlerMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.support.ModelAndViewContainer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.HandlerMapping;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MatrixVariableMapMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        MatrixVariable matrixVariable = parameter.getParameterAnnotation(MatrixVariable.class);
        return matrixVariable != null && Map.class.isAssignableFrom(parameter.getParameterType()) && !StringUtils.hasText(matrixVariable.name());
    }

    @Override
    @Nullable
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest request, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        Map matrixVariables = (Map)request.getAttribute(HandlerMapping.MATRIX_VARIABLES_ATTRIBUTE, 0);
        if (CollectionUtils.isEmpty(matrixVariables)) {
            return Collections.emptyMap();
        }
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        MatrixVariable ann = parameter.getParameterAnnotation(MatrixVariable.class);
        Assert.state(ann != null, "No MatrixVariable annotation");
        String pathVariable = ann.pathVar();
        if (!pathVariable.equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
            MultiValueMap mapForPathVariable = (MultiValueMap)matrixVariables.get(pathVariable);
            if (mapForPathVariable == null) {
                return Collections.emptyMap();
            }
            map.putAll(mapForPathVariable);
        } else {
            for (MultiValueMap vars : matrixVariables.values()) {
                vars.forEach((name, values) -> {
                    for (String value : values) {
                        map.add(name, value);
                    }
                });
            }
        }
        return this.isSingleValueMap(parameter) ? map.toSingleValueMap() : map;
    }

    private boolean isSingleValueMap(MethodParameter parameter) {
        ResolvableType[] genericTypes;
        if (!MultiValueMap.class.isAssignableFrom(parameter.getParameterType()) && (genericTypes = ResolvableType.forMethodParameter(parameter).getGenerics()).length == 2) {
            Class<?> declaredClass = genericTypes[1].getRawClass();
            return declaredClass == null || !List.class.isAssignableFrom(declaredClass);
        }
        return false;
    }
}

