/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation;

import com.baidu.cloud.thirdparty.springframework.core.MethodParameter;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.bind.annotation.PathVariable;
import com.baidu.cloud.thirdparty.springframework.web.bind.support.WebDataBinderFactory;
import com.baidu.cloud.thirdparty.springframework.web.context.request.NativeWebRequest;
import com.baidu.cloud.thirdparty.springframework.web.method.support.HandlerMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.support.ModelAndViewContainer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.HandlerMapping;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PathVariableMapMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        PathVariable ann = parameter.getParameterAnnotation(PathVariable.class);
        return ann != null && Map.class.isAssignableFrom(parameter.getParameterType()) && !StringUtils.hasText(ann.value());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        Map uriTemplateVars = (Map)webRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
        if (!CollectionUtils.isEmpty(uriTemplateVars)) {
            return new LinkedHashMap(uriTemplateVars);
        }
        return Collections.emptyMap();
    }
}

