/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.resource;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceResolverChain;
import java.util.List;

public abstract class AbstractResourceResolver
implements ResourceResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    @Nullable
    public Resource resolveResource(@Nullable HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Resolving resource for request path \"" + requestPath + "\"");
        }
        return this.resolveResourceInternal(request, requestPath, locations, chain);
    }

    @Override
    @Nullable
    public String resolveUrlPath(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Resolving public URL for resource path \"" + resourceUrlPath + "\"");
        }
        return this.resolveUrlPathInternal(resourceUrlPath, locations, chain);
    }

    @Nullable
    protected abstract Resource resolveResourceInternal(@Nullable HttpServletRequest var1, String var2, List<? extends Resource> var3, ResourceResolverChain var4);

    @Nullable
    protected abstract String resolveUrlPathInternal(String var1, List<? extends Resource> var2, ResourceResolverChain var3);
}

