/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.resource;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.cache.Cache;
import com.baidu.cloud.thirdparty.springframework.cache.CacheManager;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceTransformer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceTransformerChain;
import java.io.IOException;

public class CachingResourceTransformer
implements ResourceTransformer {
    private static final Log logger = LogFactory.getLog(CachingResourceTransformer.class);
    private final Cache cache;

    public CachingResourceTransformer(Cache cache) {
        Assert.notNull((Object)cache, "Cache is required");
        this.cache = cache;
    }

    public CachingResourceTransformer(CacheManager cacheManager, String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("Cache '" + cacheName + "' not found");
        }
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        Resource transformed = this.cache.get((Object)resource, Resource.class);
        if (transformed != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Found match: " + transformed);
            }
            return transformed;
        }
        transformed = transformerChain.transform(request, resource);
        if (logger.isTraceEnabled()) {
            logger.trace("Putting transformed resource in cache: " + transformed);
        }
        this.cache.put(resource, transformed);
        return transformed;
    }
}

