/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.tags;

import com.baidu.cloud.thirdparty.servlet.jsp.JspException;
import com.baidu.cloud.thirdparty.servlet.jsp.tagext.BodyContent;
import com.baidu.cloud.thirdparty.servlet.jsp.tagext.BodyTag;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import com.baidu.cloud.thirdparty.springframework.web.util.JavaScriptUtils;
import java.io.IOException;

public class EscapeBodyTag
extends HtmlEscapingAwareTag
implements BodyTag {
    private boolean javaScriptEscape = false;
    @Nullable
    private BodyContent bodyContent;

    public void setJavaScriptEscape(boolean javaScriptEscape) throws JspException {
        this.javaScriptEscape = javaScriptEscape;
    }

    @Override
    protected int doStartTagInternal() {
        return 2;
    }

    public void doInitBody() {
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    public int doAfterBody() throws JspException {
        try {
            String content = this.readBodyContent();
            content = this.htmlEscape(content);
            content = this.javaScriptEscape ? JavaScriptUtils.javaScriptEscape(content) : content;
            this.writeBodyContent(content);
        }
        catch (IOException ex) {
            throw new JspException("Could not write escaped body", (Throwable)ex);
        }
        return 0;
    }

    protected String readBodyContent() throws IOException {
        Assert.state(this.bodyContent != null, "No BodyContent set");
        return this.bodyContent.getString();
    }

    protected void writeBodyContent(String content) throws IOException {
        Assert.state(this.bodyContent != null, "No BodyContent set");
        this.bodyContent.getEnclosingWriter().print(content);
    }
}

