/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.theme;

import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.web.servlet.ThemeResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import com.baidu.cloud.thirdparty.springframework.web.servlet.support.RequestContextUtils;

public class ThemeChangeInterceptor
extends HandlerInterceptorAdapter {
    public static final String DEFAULT_PARAM_NAME = "theme";
    private String paramName = "theme";

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public String getParamName() {
        return this.paramName;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        String newTheme = request.getParameter(this.paramName);
        if (newTheme != null) {
            ThemeResolver themeResolver = RequestContextUtils.getThemeResolver(request);
            if (themeResolver == null) {
                throw new IllegalStateException("No ThemeResolver found: not in a DispatcherServlet request?");
            }
            themeResolver.setThemeName(request, response, newTheme);
        }
        return true;
    }
}

