/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.view.freemarker;

import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.context.ResourceLoaderAware;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.ui.freemarker.FreeMarkerConfigurationFactory;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.context.ServletContextAware;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.freemarker.FreeMarkerConfig;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.List;

public class FreeMarkerConfigurer
extends FreeMarkerConfigurationFactory
implements FreeMarkerConfig,
InitializingBean,
ResourceLoaderAware,
ServletContextAware {
    @Nullable
    private Configuration configuration;
    @Nullable
    private TaglibFactory taglibFactory;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.taglibFactory = new TaglibFactory(servletContext);
    }

    @Override
    public void afterPropertiesSet() throws IOException, TemplateException {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
        }
    }

    protected void postProcessTemplateLoaders(List<TemplateLoader> templateLoaders) {
        templateLoaders.add((TemplateLoader)new ClassTemplateLoader(FreeMarkerConfigurer.class, ""));
        this.logger.info("ClassTemplateLoader for Spring macros added to FreeMarker configuration");
    }

    @Override
    public Configuration getConfiguration() {
        Assert.state(this.configuration != null, "No Configuration available");
        return this.configuration;
    }

    @Override
    public TaglibFactory getTaglibFactory() {
        Assert.state(this.taglibFactory != null, "No TaglibFactory available");
        return this.taglibFactory;
    }
}

