/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.view.json;

import com.baidu.cloud.thirdparty.jackson.annotation.JsonView;
import com.baidu.cloud.thirdparty.jackson.core.JsonEncoding;
import com.baidu.cloud.thirdparty.jackson.core.JsonGenerator;
import com.baidu.cloud.thirdparty.jackson.databind.ObjectMapper;
import com.baidu.cloud.thirdparty.jackson.databind.ObjectWriter;
import com.baidu.cloud.thirdparty.jackson.databind.SerializationFeature;
import com.baidu.cloud.thirdparty.jackson.databind.ser.FilterProvider;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.http.converter.json.MappingJacksonValue;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.AbstractView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public abstract class AbstractJackson2View
extends AbstractView {
    private ObjectMapper objectMapper;
    private JsonEncoding encoding = JsonEncoding.UTF8;
    @Nullable
    private Boolean prettyPrint;
    private boolean disableCaching = true;
    protected boolean updateContentLength = false;

    protected AbstractJackson2View(ObjectMapper objectMapper, String contentType) {
        this.objectMapper = objectMapper;
        this.configurePrettyPrint();
        this.setContentType(contentType);
        this.setExposePathVariables(false);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.configurePrettyPrint();
    }

    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setEncoding(JsonEncoding encoding) {
        Assert.notNull((Object)encoding, "'encoding' must not be null");
        this.encoding = encoding;
    }

    public final JsonEncoding getEncoding() {
        return this.encoding;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        this.configurePrettyPrint();
    }

    private void configurePrettyPrint() {
        if (this.prettyPrint != null) {
            this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, (boolean)this.prettyPrint);
        }
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    public void setUpdateContentLength(boolean updateContentLength) {
        this.updateContentLength = updateContentLength;
    }

    @Override
    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        this.setResponseContentType(request, response);
        response.setCharacterEncoding(this.encoding.getJavaName());
        if (this.disableCaching) {
            response.addHeader("Cache-Control", "no-store");
        }
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OutputStream stream;
        ByteArrayOutputStream temporaryStream = null;
        if (this.updateContentLength) {
            temporaryStream = this.createTemporaryOutputStream();
            stream = temporaryStream;
        } else {
            stream = response.getOutputStream();
        }
        Object value = this.filterAndWrapModel(model, request);
        this.writeContent(stream, value);
        if (temporaryStream != null) {
            this.writeToResponse(response, temporaryStream);
        }
    }

    protected Object filterAndWrapModel(Map<String, Object> model, HttpServletRequest request) {
        Object value = this.filterModel(model);
        Class serializationView = (Class)model.get(JsonView.class.getName());
        FilterProvider filters = (FilterProvider)model.get(FilterProvider.class.getName());
        if (serializationView != null || filters != null) {
            MappingJacksonValue container = new MappingJacksonValue(value);
            if (serializationView != null) {
                container.setSerializationView(serializationView);
            }
            if (filters != null) {
                container.setFilters(filters);
            }
            value = container;
        }
        return value;
    }

    protected void writeContent(OutputStream stream, Object object) throws IOException {
        ObjectWriter objectWriter;
        JsonGenerator generator = this.objectMapper.getFactory().createGenerator(stream, this.encoding);
        this.writePrefix(generator, object);
        Object value = object;
        Class<?> serializationView = null;
        FilterProvider filters = null;
        if (value instanceof MappingJacksonValue) {
            MappingJacksonValue container = (MappingJacksonValue)value;
            value = container.getValue();
            serializationView = container.getSerializationView();
            filters = container.getFilters();
        }
        ObjectWriter objectWriter2 = objectWriter = serializationView != null ? this.objectMapper.writerWithView(serializationView) : this.objectMapper.writer();
        if (filters != null) {
            objectWriter = objectWriter.with(filters);
        }
        objectWriter.writeValue(generator, value);
        this.writeSuffix(generator, object);
        generator.flush();
    }

    public abstract void setModelKey(String var1);

    protected abstract Object filterModel(Map<String, Object> var1);

    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
    }

    protected void writeSuffix(JsonGenerator generator, Object object) throws IOException {
    }
}

