/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client;

import com.baidu.disconf.client.config.ConfigMgr;
import com.baidu.disconf.client.config.DisClientConfig;
import com.baidu.disconf.client.core.DisconfCoreFactory;
import com.baidu.disconf.client.core.DisconfCoreMgr;
import com.baidu.disconf.client.scan.ScanFactory;
import com.baidu.disconf.client.scan.ScanMgr;
import com.baidu.disconf.client.store.DisconfStoreProcessorFactory;
import com.baidu.disconf.client.support.registry.Registry;
import com.baidu.disconf.client.support.registry.RegistryFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DisconfMgr
implements ApplicationContextAware {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisconfMgr.class);
    private boolean isFirstInit = false;
    private boolean isSecondInit = false;
    private ApplicationContext applicationContext;
    private DisconfCoreMgr disconfCoreMgr = null;
    private ScanMgr scanMgr = null;
    protected static final DisconfMgr INSTANCE = new DisconfMgr();

    public static DisconfMgr getInstance() {
        return INSTANCE;
    }

    private DisconfMgr() {
    }

    public synchronized void start(List<String> scanPackageList) {
        this.firstScan(scanPackageList);
        this.secondScan();
    }

    protected synchronized void firstScan(List<String> scanPackageList) {
        if (this.isFirstInit) {
            LOGGER.info("DisConfMgr has been init, ignore........");
            return;
        }
        try {
            ConfigMgr.init();
            LOGGER.info("******************************* DISCONF START FIRST SCAN *******************************");
            Registry registry = RegistryFactory.getSpringRegistry(this.applicationContext);
            this.scanMgr = ScanFactory.getScanMgr(registry);
            this.scanMgr.firstScan(scanPackageList);
            this.disconfCoreMgr = DisconfCoreFactory.getDisconfCoreMgr(registry);
            this.disconfCoreMgr.process();
            this.isFirstInit = true;
            LOGGER.info("******************************* DISCONF END FIRST SCAN *******************************");
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    protected synchronized void secondScan() {
        if (!this.isFirstInit) {
            LOGGER.info("should run First Scan before Second Scan.");
            return;
        }
        if (this.isSecondInit) {
            LOGGER.info("should not run twice.");
            return;
        }
        LOGGER.info("******************************* DISCONF START SECOND SCAN *******************************");
        try {
            if (this.scanMgr != null) {
                this.scanMgr.secondScan();
            }
            if (this.disconfCoreMgr != null) {
                this.disconfCoreMgr.inject2DisconfInstance();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        this.isSecondInit = true;
        if (DisClientConfig.getInstance().ENABLE_DISCONF) {
            LOGGER.info("Conf File Map: {}", (Object)DisconfStoreProcessorFactory.getDisconfStoreFileProcessor().confToString());
            LOGGER.info("Conf Item Map: {}", (Object)DisconfStoreProcessorFactory.getDisconfStoreItemProcessor().confToString());
        }
        LOGGER.info("******************************* DISCONF END *******************************");
    }

    public synchronized void reloadableScan(String filename) {
        if (!this.isFirstInit) {
            return;
        }
        if (!DisClientConfig.getInstance().ENABLE_DISCONF) {
            return;
        }
        try {
            if (this.scanMgr != null) {
                this.scanMgr.reloadableScan(filename);
            }
            if (this.disconfCoreMgr != null) {
                this.disconfCoreMgr.processFile(filename);
            }
            LOGGER.debug("disconf reloadable file: {}", (Object)filename);
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    public synchronized void close() {
        try {
            LOGGER.info("******************************* DISCONF CLOSE *******************************");
            if (this.disconfCoreMgr != null) {
                this.disconfCoreMgr.release();
            }
            this.isFirstInit = false;
            this.isSecondInit = false;
        }
        catch (Exception e) {
            LOGGER.error("DisConfMgr close Failed.", (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

