/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.common.constants;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public enum SupportFileTypeEnum {
    PROPERTIES(0, "properties"),
    XML(1, "xml"),
    ANY(3, "*");

    private int type = 0;
    private String modelName = null;

    private SupportFileTypeEnum(int type, String modelName) {
        this.type = type;
        this.modelName = modelName;
    }

    public static SupportFileTypeEnum getByFileName(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        if (StringUtils.isEmpty((String)extension)) {
            return ANY;
        }
        for (SupportFileTypeEnum supportFileTypeEnum : SupportFileTypeEnum.values()) {
            if (!extension.equals(supportFileTypeEnum.modelName)) continue;
            return supportFileTypeEnum;
        }
        return ANY;
    }

    public static SupportFileTypeEnum getByType(int type) {
        int index = 0;
        for (SupportFileTypeEnum supportFileTypeEnum : SupportFileTypeEnum.values()) {
            if (type == index) {
                return supportFileTypeEnum;
            }
            ++index;
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }
}

