/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.utils;

import com.baidu.disconf.core.common.utils.ClassLoaderUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigLoaderUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ConfigLoaderUtils.class);

    private ConfigLoaderUtils() {
    }

    private static Properties loadWithTomcatMode(String propertyFilePath) throws Exception {
        Properties props = new Properties();
        try {
            URL url = ClassLoaderUtil.getLoader().getResource(propertyFilePath);
            URI uri = new URI(url.toString());
            props.load(new FileInputStream(uri.getPath()));
        }
        catch (Exception e) {
            props.load(ClassLoaderUtil.getLoader().getResourceAsStream(propertyFilePath));
        }
        return props;
    }

    private static Properties loadWithNormalMode(String propertyFilePath) throws Exception {
        Properties props = new Properties();
        props.load(new FileInputStream(propertyFilePath));
        return props;
    }

    public static Properties loadConfig(String propertyFilePath) throws Exception {
        try {
            return ConfigLoaderUtils.loadWithTomcatMode(propertyFilePath);
        }
        catch (Exception e1) {
            try {
                return ConfigLoaderUtils.loadWithNormalMode(propertyFilePath);
            }
            catch (Exception e2) {
                throw new Exception("cannot load config file: " + propertyFilePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static InputStream loadFile(String filePath) {
        InputStream in = null;
        try {
            in = ClassLoaderUtil.getLoader().getResourceAsStream(filePath);
            if (in == null) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(filePath);
                    return fileInputStream;
                }
                catch (FileNotFoundException e) {
                    InputStream e2;
                    block17: {
                        e2 = null;
                        if (in == null) break block17;
                        try {
                            in.close();
                        }
                        catch (IOException e3) {
                            LOGGER.error("WHY HERE!", (Throwable)e3);
                        }
                    }
                    return e2;
                }
            }
            InputStream inputStream = in;
            return inputStream;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e2) {
                    LOGGER.error("WHY HERE!", (Throwable)e2);
                }
            }
        }
    }
}

