/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.utils;

import com.baidu.disconf.client.common.annotations.DisconfFileItem;
import com.baidu.disconf.client.common.annotations.DisconfItem;
import com.baidu.disconf.client.utils.ClassUtils;
import com.baidu.disconf.core.common.constants.DisConfigTypeEnum;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MethodUtils.class);

    public static Field getFieldFromMethod(Method method, Field[] expectedFields, DisConfigTypeEnum disConfigTypeEnum) {
        String fieldName;
        if (disConfigTypeEnum.equals((Object)DisConfigTypeEnum.FILE)) {
            DisconfFileItem disconfFileItem = method.getAnnotation(DisconfFileItem.class);
            fieldName = disconfFileItem.associateField();
        } else {
            DisconfItem disItem = method.getAnnotation(DisconfItem.class);
            fieldName = disItem.associateField();
        }
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = ClassUtils.getFieldNameByGetMethodName(method.getName());
        }
        for (Field field : expectedFields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        LOGGER.error(method.toString() + " cannot get its related field name. ");
        return null;
    }

    public static Method getSetterMethodFromField(Class<?> curClass, Field field) {
        String fieldName = field.getName().toLowerCase();
        Set<Method> methods = ClassUtils.getAllMethod(curClass);
        for (Method method : methods) {
            if (!method.getName().toLowerCase().equals("set" + fieldName) && !method.getName().toLowerCase().equals("is" + fieldName)) continue;
            return method;
        }
        return null;
    }
}

