/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.http;

import com.baidubce.BceClientConfiguration;
import com.baidubce.auth.BceV1Signer;
import com.baidubce.auth.SignOptions;
import com.baidubce.auth.Signer;
import com.baidubce.http.BceHttpClient;
import com.baidubce.http.handler.ApiExplorerMetaResponseHandler;
import com.baidubce.http.handler.ApiExplorerResponseHandler;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.model.ApiExplorerRequest;
import com.baidubce.model.ApiExplorerResponse;
import com.baidubce.util.DateUtils;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;

public class ApiExplorerClient {
    private BceHttpClient client;
    private HttpResponseHandler[] responseHandlers;
    public static final String DEFAULT_CONTENT_TYPE = "application/json; charset=utf-8";
    private static final Set<String> HEADERS_TO_SIGN = Sets.newHashSet((Object[])new String[]{"host", "x-bce-date"});

    public ApiExplorerClient() {
        this((Signer)new BceV1Signer());
    }

    public ApiExplorerClient(Signer signer) {
        this.client = new BceHttpClient(new BceClientConfiguration(), signer, false);
        this.responseHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new ApiExplorerMetaResponseHandler(), new BceErrorResponseHandler(), new ApiExplorerResponseHandler()};
    }

    public ApiExplorerResponse sendRequest(ApiExplorerRequest bceRequest) {
        InternalRequest request = bceRequest.getInternalRequest();
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        if (!request.getHeaders().containsKey("Date")) {
            request.addHeader("Date", DateUtils.formatRfc822Date((Date)new Date()));
        }
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(HEADERS_TO_SIGN);
        request.setSignOptions(signOptions);
        return (ApiExplorerResponse)this.client.execute(bceRequest.getInternalRequest(), ApiExplorerResponse.class, this.responseHandlers);
    }
}

