/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import com.baomidou.dynamic.datasource.aop.DynamicAspectJExpressionPointcut;
import com.baomidou.dynamic.datasource.aop.DynamicJdkRegexpMethodPointcut;
import com.baomidou.dynamic.datasource.matcher.ExpressionMatcher;
import com.baomidou.dynamic.datasource.matcher.Matcher;
import com.baomidou.dynamic.datasource.matcher.RegexMatcher;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class DynamicDataSourceAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private Advice advice;
    private Pointcut pointcut;
    private Map<String, String> matchesCache = new HashMap<String, String>();

    public DynamicDataSourceAdvisor(List<Matcher> matchers) {
        this.pointcut = this.buildPointcut(matchers);
        this.advice = this.buildAdvice();
    }

    private Advice buildAdvice() {
        return new MethodInterceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(MethodInvocation invocation) throws Throwable {
                try {
                    Method method = invocation.getMethod();
                    String methodPath = method.getDeclaringClass().getName() + "." + method.getName();
                    DynamicDataSourceContextHolder.setDataSourceLookupKey((String)DynamicDataSourceAdvisor.this.matchesCache.get(methodPath));
                    Object object = invocation.proceed();
                    return object;
                }
                finally {
                    DynamicDataSourceContextHolder.clearDataSourceLookupKey();
                }
            }
        };
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.advice instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.advice).setBeanFactory(beanFactory);
        }
    }

    private Pointcut buildPointcut(List<Matcher> matchers) {
        ComposablePointcut composablePointcut = null;
        for (Matcher matcher : matchers) {
            Object pointcut;
            if (matcher instanceof RegexMatcher) {
                RegexMatcher regexMatcher = (RegexMatcher)matcher;
                pointcut = new DynamicJdkRegexpMethodPointcut(regexMatcher.getPattern(), regexMatcher.getDs(), this.matchesCache);
                if (composablePointcut == null) {
                    composablePointcut = new ComposablePointcut((Pointcut)pointcut);
                    continue;
                }
                composablePointcut.union((Pointcut)pointcut);
                continue;
            }
            ExpressionMatcher expressionMatcher = (ExpressionMatcher)matcher;
            pointcut = new DynamicAspectJExpressionPointcut(expressionMatcher.getExpression(), expressionMatcher.getDs(), this.matchesCache);
            if (composablePointcut == null) {
                composablePointcut = new ComposablePointcut((Pointcut)pointcut);
                continue;
            }
            composablePointcut.union((Pointcut)pointcut);
        }
        return composablePointcut;
    }

    public void setOrder(int order) {
        super.setOrder(Integer.MIN_VALUE);
    }
}

