/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spel;

import com.baomidou.dynamic.datasource.spel.DynamicDataSourceSpelParser;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DefaultDynamicDataSourceSpelParser
implements DynamicDataSourceSpelParser {
    private static final ParameterNameDiscoverer NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private static final String SESSION_PREFIX = "#session";
    private static final String HEADER_PREFIX = "#header";

    @Override
    public String parse(MethodInvocation invocation, String key) {
        if (key.startsWith(SESSION_PREFIX)) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            return request.getSession().getAttribute(key.substring(9)).toString();
        }
        if (key.startsWith(HEADER_PREFIX)) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            return request.getHeader(key.substring(8));
        }
        Method method = invocation.getMethod();
        Object[] arguments = invocation.getArguments();
        MethodBasedEvaluationContext context = new MethodBasedEvaluationContext(null, method, arguments, NAME_DISCOVERER);
        return PARSER.parseExpression(key).getValue((EvaluationContext)context).toString();
    }
}

