/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.toolkit.VersionUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class SqlExplainInterceptor
implements Interceptor {
    private static final Log logger = LogFactory.getLog(SqlExplainInterceptor.class);
    private final String minMySQLVersion = "5.6.3";
    private boolean stopProceed = false;

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        if (ms.getSqlCommandType() == SqlCommandType.DELETE || ms.getSqlCommandType() == SqlCommandType.UPDATE) {
            Executor executor = (Executor)invocation.getTarget();
            Configuration configuration = ms.getConfiguration();
            Object parameter = invocation.getArgs()[1];
            BoundSql boundSql = ms.getBoundSql(parameter);
            Connection connection = executor.getTransaction().getConnection();
            String databaseVersion = connection.getMetaData().getDatabaseProductVersion();
            if (GlobalConfigUtils.getDbType((Configuration)configuration).equals((Object)DbType.MYSQL) && VersionUtils.compare("5.6.3", databaseVersion)) {
                logger.warn("Warn: Your mysql version needs to be greater than '5.6.3' to execute of Sql Explain!");
                return invocation.proceed();
            }
            this.sqlExplain(configuration, ms, boundSql, connection, parameter);
        }
        return invocation.proceed();
    }

    protected void sqlExplain(Configuration configuration, MappedStatement mappedStatement, BoundSql boundSql, Connection connection, Object parameter) {
        StringBuilder explain = new StringBuilder("EXPLAIN ");
        explain.append(boundSql.getSql());
        String sqlExplain = explain.toString();
        StaticSqlSource sqlsource = new StaticSqlSource(configuration, sqlExplain, boundSql.getParameterMappings());
        MappedStatement.Builder builder = new MappedStatement.Builder(configuration, "explain_sql", (SqlSource)sqlsource, SqlCommandType.SELECT);
        builder.resultMaps(mappedStatement.getResultMaps()).resultSetType(mappedStatement.getResultSetType()).statementType(mappedStatement.getStatementType());
        MappedStatement queryStatement = builder.build();
        DefaultParameterHandler handler = new DefaultParameterHandler(queryStatement, parameter, boundSql);
        try (PreparedStatement stmt = connection.prepareStatement(sqlExplain);){
            handler.setParameters(stmt);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    if ("Using where".equals(rs.getString("Extra"))) continue;
                    Assert.isFalse((boolean)this.isStopProceed(), (String)("Error: Full table operation is prohibited. SQL: " + boundSql.getSql()));
                    break;
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((Throwable)e);
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
        String stopProceed = prop.getProperty("stopProceed");
        if (StringUtils.isNotEmpty((CharSequence)stopProceed)) {
            this.stopProceed = Boolean.valueOf(stopProceed);
        }
    }

    public String getMinMySQLVersion() {
        return this.minMySQLVersion;
    }

    public boolean isStopProceed() {
        return this.stopProceed;
    }

    public SqlExplainInterceptor setStopProceed(boolean stopProceed) {
        this.stopProceed = stopProceed;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlExplainInterceptor)) {
            return false;
        }
        SqlExplainInterceptor other = (SqlExplainInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$minMySQLVersion = this.getMinMySQLVersion();
        String other$minMySQLVersion = other.getMinMySQLVersion();
        if (this$minMySQLVersion == null ? other$minMySQLVersion != null : !this$minMySQLVersion.equals(other$minMySQLVersion)) {
            return false;
        }
        return this.isStopProceed() == other.isStopProceed();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlExplainInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $minMySQLVersion = this.getMinMySQLVersion();
        result = result * 59 + ($minMySQLVersion == null ? 43 : $minMySQLVersion.hashCode());
        result = result * 59 + (this.isStopProceed() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SqlExplainInterceptor(minMySQLVersion=" + this.getMinMySQLVersion() + ", stopProceed=" + this.isStopProceed() + ")";
    }
}

