/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.DB2Dialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.H2Dialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.HSQLDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.MariaDBDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.MySqlDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.OracleDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.PostgreDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLServer2005Dialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLServerDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLiteDialect;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DialectFactory {
    private static final Map<String, IDialect> DIALECT_CACHE = new ConcurrentHashMap<String, IDialect>();

    public static String buildPaginationSql(Page page, String buildSql, DbType dbType, String dialectClazz) throws Exception {
        return DialectFactory.getDialect(dbType, dialectClazz).buildPaginationSql(buildSql, DialectFactory.offsetCurrent(page), page.getSize());
    }

    public static long offsetCurrent(IPage page) {
        if (null == page) {
            return 0L;
        }
        return DialectFactory.offsetCurrent(page.getCurrent(), page.getSize());
    }

    public static long offsetCurrent(long current, long size) {
        if (current > 0L) {
            return (current - 1L) * size;
        }
        return 0L;
    }

    public static String buildPaginationSql(IPage page, String buildSql, DbType dbType, String dialectClazz) throws Exception {
        return DialectFactory.getDialect(dbType, dialectClazz).buildPaginationSql(buildSql, page.offset(), page.getSize());
    }

    /*
     * Unable to fully structure code
     */
    private static IDialect getDialect(DbType dbType, String dialectClazz) throws Exception {
        dialect = DialectFactory.DIALECT_CACHE.get(dbType.getDb());
        if (null == dialect) {
            if (StringUtils.isNotEmpty((CharSequence)dialectClazz)) {
                dialect = DialectFactory.DIALECT_CACHE.get(dialectClazz);
                if (null != dialect) {
                    return dialect;
                }
                try {
                    clazz = Class.forName(dialectClazz);
                    if (!IDialect.class.isAssignableFrom(clazz)) ** GOTO lbl19
                    dialect = (IDialect)clazz.newInstance();
                    DialectFactory.DIALECT_CACHE.put(dialectClazz, dialect);
                }
                catch (ClassNotFoundException e) {
                    throw ExceptionUtils.mpe((String)("Class :" + dialectClazz + " is not found"));
                }
            } else {
                dialect = DialectFactory.getDialectByDbType(dbType);
                DialectFactory.DIALECT_CACHE.put(dbType.getDb(), dialect);
            }
lbl19:
            // 3 sources

            Assert.notNull((Object)dialect, (String)"The value of the dialect property in mybatis configuration.xml is not defined.");
        }
        return dialect;
    }

    private static IDialect getDialectByDbType(DbType dbType) {
        if (dbType == DbType.MYSQL) {
            return new MySqlDialect();
        }
        if (dbType == DbType.MARIADB) {
            return new MariaDBDialect();
        }
        if (dbType == DbType.ORACLE) {
            return new OracleDialect();
        }
        if (dbType == DbType.DB2) {
            return new DB2Dialect();
        }
        if (dbType == DbType.H2) {
            return new H2Dialect();
        }
        if (dbType == DbType.SQL_SERVER) {
            return new SQLServerDialect();
        }
        if (dbType == DbType.SQL_SERVER2005) {
            return new SQLServer2005Dialect();
        }
        if (dbType == DbType.POSTGRE_SQL) {
            return new PostgreDialect();
        }
        if (dbType == DbType.HSQL) {
            return new HSQLDialect();
        }
        if (dbType == DbType.SQLITE) {
            return new SQLiteDialect();
        }
        throw ExceptionUtils.mpe((String)("The Database's Not Supported! DBType:" + dbType));
    }
}

