/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.handlers;

import com.baomidou.mybatisplus.core.handlers.IJsonTypeHandler;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public abstract class AbstractJsonTypeHandler<T>
extends BaseTypeHandler<T>
implements IJsonTypeHandler<T> {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final Class<?> type;
    protected Type genericType;

    public AbstractJsonTypeHandler(Class<?> type) {
        this.type = type;
        if (this.log.isTraceEnabled()) {
            this.log.trace(((Object)((Object)this)).getClass().getSimpleName() + "(" + type + ")");
        }
        Assert.notNull(type, (String)"Type argument cannot be null", (Object[])new Object[0]);
    }

    public AbstractJsonTypeHandler(Class<?> type, Field field) {
        this(type);
        this.genericType = field.getGenericType();
    }

    public void setNonNullParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, this.toJson(parameter));
    }

    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String json = rs.getString(columnName);
        return (T)(StringUtils.isBlank((CharSequence)json) ? null : this.parse(json));
    }

    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String json = rs.getString(columnIndex);
        return (T)(StringUtils.isBlank((CharSequence)json) ? null : this.parse(json));
    }

    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String json = cs.getString(columnIndex);
        return (T)(StringUtils.isBlank((CharSequence)json) ? null : this.parse(json));
    }

    public Type getFieldType() {
        return this.genericType != null ? this.genericType : this.type;
    }
}

