/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.IConfigBuilder;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.baomidou.mybatisplus.generator.config.IKeyWordsHandler;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.TypeConverts;
import com.baomidou.mybatisplus.generator.config.querys.DbQueryRegistry;
import com.baomidou.mybatisplus.generator.query.AbstractDatabaseQuery;
import com.baomidou.mybatisplus.generator.query.DefaultQuery;
import com.baomidou.mybatisplus.generator.query.IDatabaseQuery;
import com.baomidou.mybatisplus.generator.type.ITypeConvertHandler;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceConfig {
    protected final Logger logger = LoggerFactory.getLogger(DataSourceConfig.class);
    private IDbQuery dbQuery;
    private String schemaName;
    private ITypeConvert typeConvert;
    private IKeyWordsHandler keyWordsHandler;
    private String url;
    private String username;
    private String password;
    private DataSource dataSource;
    private Connection connection;
    private final Map<String, String> connectionProperties = new HashMap<String, String>();
    private Class<? extends AbstractDatabaseQuery> databaseQueryClass = DefaultQuery.class;
    private ITypeConvertHandler typeConvertHandler;

    private DataSourceConfig() {
    }

    @NotNull
    public IDbQuery getDbQuery() {
        if (null == this.dbQuery) {
            DbType dbType = this.getDbType();
            DbQueryRegistry dbQueryRegistry = new DbQueryRegistry();
            this.dbQuery = Optional.ofNullable(dbQueryRegistry.getDbQuery(dbType)).orElseGet(() -> dbQueryRegistry.getDbQuery(DbType.MYSQL));
        }
        return this.dbQuery;
    }

    @NotNull
    public DbType getDbType() {
        return this.getDbType(this.url.toLowerCase());
    }

    @NotNull
    private DbType getDbType(@NotNull String str) {
        if (str.contains(":mysql:") || str.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (str.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (str.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (str.contains(":sqlserver:")) {
            return DbType.SQL_SERVER;
        }
        if (str.contains(":db2:")) {
            return DbType.DB2;
        }
        if (str.contains(":mariadb:")) {
            return DbType.MARIADB;
        }
        if (str.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (str.contains(":h2:")) {
            return DbType.H2;
        }
        if (str.contains(":kingbase:") || str.contains(":kingbase8:")) {
            return DbType.KINGBASE_ES;
        }
        if (str.contains(":dm:")) {
            return DbType.DM;
        }
        if (str.contains(":zenith:")) {
            return DbType.GAUSS;
        }
        if (str.contains(":oscar:")) {
            return DbType.OSCAR;
        }
        if (str.contains(":firebird:")) {
            return DbType.FIREBIRD;
        }
        if (str.contains(":xugu:")) {
            return DbType.XU_GU;
        }
        if (str.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (str.contains(":sybase:")) {
            return DbType.SYBASE;
        }
        return DbType.OTHER;
    }

    @NotNull
    public ITypeConvert getTypeConvert() {
        if (null == this.typeConvert) {
            DbType dbType = this.getDbType();
            this.typeConvert = TypeConverts.getTypeConvert(dbType);
            if (null == this.typeConvert) {
                this.typeConvert = MySqlTypeConvert.INSTANCE;
            }
        }
        return this.typeConvert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Connection getConn() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            DataSourceConfig dataSourceConfig = this;
            synchronized (dataSourceConfig) {
                if (this.dataSource != null) {
                    this.connection = this.dataSource.getConnection();
                } else {
                    Properties properties = new Properties();
                    this.connectionProperties.forEach(properties::setProperty);
                    properties.put("user", this.username);
                    properties.put("password", this.password);
                    this.processProperties(properties);
                    this.connection = DriverManager.getConnection(this.url, properties);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return this.connection;
    }

    private void processProperties(Properties properties) {
        if (this.databaseQueryClass.getName().equals(DefaultQuery.class.getName())) {
            switch (this.getDbType()) {
                case MYSQL: {
                    properties.put("remarks", "true");
                    properties.put("useInformationSchema", "true");
                    break;
                }
                case ORACLE: {
                    properties.put("remarks", "true");
                    properties.put("remarksReporting", "true");
                }
            }
        }
    }

    @Nullable
    protected String getDefaultSchema() {
        DbType dbType = this.getDbType();
        String schema = null;
        if (DbType.POSTGRE_SQL == dbType) {
            schema = "public";
        } else if (DbType.KINGBASE_ES == dbType) {
            schema = "PUBLIC";
        } else if (DbType.DB2 == dbType) {
            schema = "current schema";
        } else if (DbType.ORACLE == dbType) {
            schema = this.username.toUpperCase();
        }
        return schema;
    }

    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Nullable
    public IKeyWordsHandler getKeyWordsHandler() {
        return this.keyWordsHandler;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @NotNull
    public Class<? extends IDatabaseQuery> getDatabaseQueryClass() {
        return this.databaseQueryClass;
    }

    @Nullable
    public ITypeConvertHandler getTypeConvertHandler() {
        return this.typeConvertHandler;
    }

    public static class Builder
    implements IConfigBuilder<DataSourceConfig> {
        private final DataSourceConfig dataSourceConfig = new DataSourceConfig();

        private Builder() {
        }

        public Builder(@NotNull String url, String username, String password) {
            this();
            if (StringUtils.isBlank((CharSequence)url)) {
                throw new RuntimeException("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u6b63\u786e\u8f93\u5165 url \u914d\u7f6e\u4fe1\u606f\uff01");
            }
            this.dataSourceConfig.url = url;
            this.dataSourceConfig.username = username;
            this.dataSourceConfig.password = password;
        }

        public Builder(@NotNull DataSource dataSource) {
            this();
            this.dataSourceConfig.dataSource = dataSource;
            try {
                Connection conn = dataSource.getConnection();
                this.dataSourceConfig.url = conn.getMetaData().getURL();
                try {
                    this.dataSourceConfig.schemaName = conn.getSchema();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.dataSourceConfig.connection = conn;
                this.dataSourceConfig.username = conn.getMetaData().getUserName();
            }
            catch (SQLException ex) {
                throw new RuntimeException("\u6784\u5efa\u6570\u636e\u5e93\u914d\u7f6e\u5bf9\u8c61\u5931\u8d25!", ex);
            }
        }

        public Builder dbQuery(@NotNull IDbQuery dbQuery) {
            this.dataSourceConfig.dbQuery = dbQuery;
            return this;
        }

        public Builder schema(@NotNull String schemaName) {
            this.dataSourceConfig.schemaName = schemaName;
            return this;
        }

        public Builder typeConvert(@NotNull ITypeConvert typeConvert) {
            this.dataSourceConfig.typeConvert = typeConvert;
            return this;
        }

        public Builder keyWordsHandler(@NotNull IKeyWordsHandler keyWordsHandler) {
            this.dataSourceConfig.keyWordsHandler = keyWordsHandler;
            return this;
        }

        public Builder databaseQueryClass(@NotNull Class<? extends AbstractDatabaseQuery> databaseQueryClass) {
            this.dataSourceConfig.databaseQueryClass = databaseQueryClass;
            return this;
        }

        public Builder typeConvertHandler(@NotNull ITypeConvertHandler typeConvertHandler) {
            this.dataSourceConfig.typeConvertHandler = typeConvertHandler;
            return this;
        }

        public Builder addConnectionProperty(@NotNull String key, @NotNull String value) {
            this.dataSourceConfig.connectionProperties.put(key, value);
            return this;
        }

        @Override
        public DataSourceConfig build() {
            return this.dataSourceConfig;
        }
    }
}

