/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.util;

import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static String getSimpleName(String className) {
        return StringUtils.isBlank((CharSequence)className) ? null : className.substring(className.lastIndexOf(".") + 1);
    }

    public static Class<?> toClassConfident(String name) {
        try {
            return Class.forName(name, false, ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException ex) {
                throw ExceptionUtils.mpe((String)"\u627e\u4e0d\u5230\u6307\u5b9a\u7684class\uff01\u8bf7\u4ec5\u5728\u660e\u786e\u786e\u5b9a\u4f1a\u6709 class \u7684\u65f6\u5019\uff0c\u8c03\u7528\u8be5\u65b9\u6cd5", (Throwable)e, (Object[])new Object[0]);
            }
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }
}

