/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.enums;

public enum DBType {
    MYSQL("mysql", "`%s`", "MySql\u6570\u636e\u5e93"),
    ORACLE("oracle", null, "Oracle\u6570\u636e\u5e93"),
    DB2("db2", "`%s`", "DB2\u6570\u636e\u5e93"),
    H2("h2", null, "H2\u6570\u636e\u5e93"),
    HSQL("hsql", null, "HSQL\u6570\u636e\u5e93"),
    SQLITE("sqlite", "`%s`", "SQLite\u6570\u636e\u5e93"),
    POSTGRE("postgresql", "\"%s\"", "Postgre\u6570\u636e\u5e93"),
    SQLSERVER2005("sqlserver2005", "[%s]", "SQLServer2005\u6570\u636e\u5e93"),
    SQLSERVER("sqlserver", "[%s]", "SQLServer\u6570\u636e\u5e93"),
    OTHER("other", null, "\u5176\u4ed6\u6570\u636e\u5e93");

    private final String db;
    private final String quote;
    private final String desc;

    private DBType(String db, String quote, String desc) {
        this.db = db;
        this.quote = quote;
        this.desc = desc;
    }

    public static DBType getDBType(String dbType) {
        DBType[] dts;
        for (DBType dt : dts = DBType.values()) {
            if (!dt.getDb().equalsIgnoreCase(dbType)) continue;
            return dt;
        }
        return MYSQL;
    }

    public String getDb() {
        return this.db;
    }

    public String getQuote() {
        return this.quote;
    }

    public String getDesc() {
        return this.desc;
    }
}

