/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins;

import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.toolkit.PluginUtils;
import com.baomidou.mybatisplus.toolkit.SqlUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.SystemClock;
import java.lang.reflect.Proxy;
import java.sql.Statement;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;

@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class PerformanceInterceptor
implements Interceptor {
    private long maxTime = 0L;
    private boolean format = false;

    public Object intercept(Invocation invocation) throws Throwable {
        Object firstArg = invocation.getArgs()[0];
        Statement statement = Proxy.isProxyClass(firstArg.getClass()) ? (Statement)SystemMetaObject.forObject((Object)firstArg).getValue("h.statement") : (Statement)firstArg;
        try {
            statement.getClass().getDeclaredField("stmt");
            statement = (Statement)SystemMetaObject.forObject((Object)statement).getValue("stmt.statement");
        }
        catch (Exception e) {
            // empty catch block
        }
        String originalSql = statement.toString();
        int index = originalSql.indexOf(58);
        String sql = originalSql;
        if (index > 0) {
            sql = originalSql.substring(index + 1, originalSql.length());
        }
        long start = SystemClock.now();
        Object result = invocation.proceed();
        long end = SystemClock.now();
        long timing = end - start;
        String formatSql = SqlUtils.sqlFormat(sql, this.format);
        Object target = PluginUtils.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)target);
        MappedStatement ms = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        System.err.println(" Time\uff1a" + timing + " ms" + " - ID\uff1a" + ms.getId() + "\n Execute SQL\uff1a" + formatSql + "\n");
        if (this.maxTime >= 1L && timing > this.maxTime) {
            throw new MybatisPlusException(" The SQL execution time is too large, please optimize ! ");
        }
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
        String maxTime = prop.getProperty("maxTime");
        String format = prop.getProperty("format");
        if (StringUtils.isNotEmpty(maxTime)) {
            this.maxTime = Long.parseLong(maxTime);
        }
        if (StringUtils.isNotEmpty(format)) {
            this.format = Boolean.valueOf(format);
        }
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public boolean isFormat() {
        return this.format;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }
}

