/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.pagination;

import com.baomidou.mybatisplus.enums.DBType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.pagination.IDialect;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.plugins.pagination.dialects.DB2Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.H2Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.HSQLDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.MySqlDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.OracleDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.PostgreDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLServer2005Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLServerDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLiteDialect;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import org.apache.ibatis.session.RowBounds;

public class DialectFactory {
    public static String buildPaginationSql(Pagination page, String buildSql, String dialectType, String dialectClazz) throws Exception {
        return DialectFactory.getiDialect(dialectType, dialectClazz).buildPaginationSql(buildSql, page.getOffsetCurrent(), page.getSize());
    }

    public static String buildPaginationSql(RowBounds rowBounds, String buildSql, String dialectType, String dialectClazz) throws Exception {
        return DialectFactory.getiDialect(dialectType, dialectClazz).buildPaginationSql(buildSql, rowBounds.getOffset(), rowBounds.getLimit());
    }

    private static IDialect getiDialect(String dialectType, String dialectClazz) throws Exception {
        IDialect dialect = null;
        if (StringUtils.isNotEmpty(dialectType)) {
            dialect = DialectFactory.getDialectByDbtype(dialectType);
        } else if (StringUtils.isNotEmpty(dialectClazz)) {
            try {
                Class<?> clazz = Class.forName(dialectClazz);
                if (IDialect.class.isAssignableFrom(clazz)) {
                    dialect = (IDialect)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                throw new MybatisPlusException("Class :" + dialectClazz + " is not found");
            }
        }
        if (dialect == null) {
            throw new MybatisPlusException("The value of the dialect property in mybatis configuration.xml is not defined.");
        }
        return dialect;
    }

    private static IDialect getDialectByDbtype(String dbType) {
        IDialect dialect;
        switch (DBType.getDBType(dbType)) {
            case MYSQL: {
                dialect = MySqlDialect.INSTANCE;
                break;
            }
            case ORACLE: {
                dialect = OracleDialect.INSTANCE;
                break;
            }
            case DB2: {
                dialect = DB2Dialect.INSTANCE;
                break;
            }
            case H2: {
                dialect = H2Dialect.INSTANCE;
                break;
            }
            case SQLSERVER: {
                dialect = SQLServerDialect.INSTANCE;
                break;
            }
            case SQLSERVER2005: {
                dialect = SQLServer2005Dialect.INSTANCE;
                break;
            }
            case POSTGRE: {
                dialect = PostgreDialect.INSTANCE;
                break;
            }
            case HSQL: {
                dialect = HSQLDialect.INSTANCE;
                break;
            }
            case SQLITE: {
                dialect = SQLiteDialect.INSTANCE;
                break;
            }
            default: {
                throw new MybatisPlusException("The Database's Not Supported! DBType:" + dbType);
            }
        }
        return dialect;
    }
}

