/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.spring;

import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.toolkit.SystemClock;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.ResourceUtils;
import org.xml.sax.EntityResolver;

public class MybatisMapperRefresh
implements Runnable {
    private static final Log logger = LogFactory.getLog(MybatisMapperRefresh.class);
    private static final Map<String, List<Resource>> jarMapper = new HashMap<String, List<Resource>>();
    private SqlSessionFactory sqlSessionFactory;
    @Deprecated
    private Resource[] mapperLocations;
    private Long beforeTime = 0L;
    private Configuration configuration;
    private boolean enabled;
    private Set<String> fileSet;
    private int delaySeconds = 10;
    private int sleepSeconds = 20;

    @Deprecated
    public MybatisMapperRefresh(Resource[] mapperLocations, SqlSessionFactory sqlSessionFactory, int delaySeconds, int sleepSeconds, boolean enabled) {
        this.mapperLocations = (Resource[])mapperLocations.clone();
        this.sqlSessionFactory = sqlSessionFactory;
        this.delaySeconds = delaySeconds;
        this.enabled = enabled;
        this.sleepSeconds = sleepSeconds;
        this.configuration = sqlSessionFactory.getConfiguration();
        this.run();
    }

    @Deprecated
    public MybatisMapperRefresh(Resource[] mapperLocations, SqlSessionFactory sqlSessionFactory, boolean enabled) {
        this.mapperLocations = (Resource[])mapperLocations.clone();
        this.sqlSessionFactory = sqlSessionFactory;
        this.enabled = enabled;
        this.configuration = sqlSessionFactory.getConfiguration();
        this.run();
    }

    public MybatisMapperRefresh(SqlSessionFactory sqlSessionFactory, boolean enabled) throws Exception {
        this.sqlSessionFactory = sqlSessionFactory;
        this.enabled = enabled;
        this.configuration = sqlSessionFactory.getConfiguration();
        this.run();
    }

    public MybatisMapperRefresh(SqlSessionFactory sqlSessionFactory, int delaySeconds, int sleepSeconds, boolean enabled) throws Exception {
        this.sqlSessionFactory = sqlSessionFactory;
        this.delaySeconds = delaySeconds;
        this.sleepSeconds = sleepSeconds;
        this.enabled = enabled;
        this.configuration = sqlSessionFactory.getConfiguration();
        this.run();
    }

    @Override
    public void run() {
        final GlobalConfiguration globalConfig = GlobalConfiguration.getGlobalConfig(this.configuration);
        if (this.enabled) {
            this.beforeTime = SystemClock.now();
            final MybatisMapperRefresh runnable = this;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (MybatisMapperRefresh.this.fileSet == null) {
                        MybatisMapperRefresh.this.fileSet = new HashSet();
                        for (Resource mapperLocation : MybatisMapperRefresh.this.mapperLocations) {
                            try {
                                if (ResourceUtils.isJarURL((URL)mapperLocation.getURL())) {
                                    String key = new UrlResource(ResourceUtils.extractJarFileURL((URL)mapperLocation.getURL())).getFile().getPath();
                                    MybatisMapperRefresh.this.fileSet.add(key);
                                    if (jarMapper.get(key) != null) {
                                        ((List)jarMapper.get(key)).add(mapperLocation);
                                        continue;
                                    }
                                    ArrayList<Resource> resourcesList = new ArrayList<Resource>();
                                    resourcesList.add(mapperLocation);
                                    jarMapper.put(key, resourcesList);
                                    continue;
                                }
                                MybatisMapperRefresh.this.fileSet.add(mapperLocation.getFile().getPath());
                            }
                            catch (IOException ioException) {
                                ioException.printStackTrace();
                            }
                        }
                    }
                    try {
                        Thread.sleep(MybatisMapperRefresh.this.delaySeconds * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    while (true) {
                        try {
                            for (String filePath : MybatisMapperRefresh.this.fileSet) {
                                File file = new File(filePath);
                                if (!file.isFile() || file.lastModified() <= MybatisMapperRefresh.this.beforeTime) continue;
                                globalConfig.setRefresh(true);
                                List removeList = (List)jarMapper.get(filePath);
                                if (removeList != null && !removeList.isEmpty()) {
                                    for (Resource resource : removeList) {
                                        runnable.refresh(resource);
                                    }
                                    continue;
                                }
                                runnable.refresh((Resource)new FileSystemResource(file));
                            }
                            if (globalConfig.isRefresh()) {
                                MybatisMapperRefresh.this.beforeTime = SystemClock.now();
                            }
                            globalConfig.setRefresh(true);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        try {
                            Thread.sleep(MybatisMapperRefresh.this.sleepSeconds * 1000);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }, "mybatis-plus MapperRefresh").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(Resource resource) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        this.configuration = this.sqlSessionFactory.getConfiguration();
        boolean isSupper = this.configuration.getClass().getSuperclass() == Configuration.class;
        try {
            Field loadedResourcesField = isSupper ? this.configuration.getClass().getSuperclass().getDeclaredField("loadedResources") : this.configuration.getClass().getDeclaredField("loadedResources");
            loadedResourcesField.setAccessible(true);
            Set loadedResourcesSet = (Set)loadedResourcesField.get(this.configuration);
            XPathParser xPathParser = new XPathParser(resource.getInputStream(), true, this.configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver());
            XNode context = xPathParser.evalNode("/mapper");
            String namespace = context.getStringAttribute("namespace");
            Field field = MapperRegistry.class.getDeclaredField("knownMappers");
            field.setAccessible(true);
            Map mapConfig = (Map)field.get(this.configuration.getMapperRegistry());
            mapConfig.remove(Resources.classForName((String)namespace));
            loadedResourcesSet.remove(resource.toString());
            this.configuration.getCacheNames().remove(namespace);
            this.cleanParameterMap(context.evalNodes("/mapper/parameterMap"), namespace);
            this.cleanResultMap(context.evalNodes("/mapper/resultMap"), namespace);
            this.cleanKeyGenerators(context.evalNodes("insert|update"), namespace);
            this.cleanSqlElement(context.evalNodes("/mapper/sql"), namespace);
            XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(resource.getInputStream(), this.sqlSessionFactory.getConfiguration(), resource.toString(), this.sqlSessionFactory.getConfiguration().getSqlFragments());
            xmlMapperBuilder.parse();
            logger.debug("refresh: '" + resource + "', success!");
        }
        catch (IOException e) {
            logger.error("Refresh IOException :" + e.getMessage());
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    private void cleanParameterMap(List<XNode> list, String namespace) {
        for (XNode parameterMapNode : list) {
            String id = parameterMapNode.getStringAttribute("id");
            this.configuration.getParameterMaps().remove(namespace + "." + id);
        }
    }

    private void cleanResultMap(List<XNode> list, String namespace) {
        for (XNode resultMapNode : list) {
            String id = resultMapNode.getStringAttribute("id", resultMapNode.getValueBasedIdentifier());
            this.configuration.getResultMapNames().remove(id);
            this.configuration.getResultMapNames().remove(namespace + "." + id);
            this.clearResultMap(resultMapNode, namespace);
        }
    }

    private void clearResultMap(XNode xNode, String namespace) {
        for (XNode resultChild : xNode.getChildren()) {
            if (!"association".equals(resultChild.getName()) && !"collection".equals(resultChild.getName()) && !"case".equals(resultChild.getName()) || resultChild.getStringAttribute("select") != null) continue;
            this.configuration.getResultMapNames().remove(resultChild.getStringAttribute("id", resultChild.getValueBasedIdentifier()));
            this.configuration.getResultMapNames().remove(namespace + "." + resultChild.getStringAttribute("id", resultChild.getValueBasedIdentifier()));
            if (resultChild.getChildren() == null || resultChild.getChildren().isEmpty()) continue;
            this.clearResultMap(resultChild, namespace);
        }
    }

    private void cleanKeyGenerators(List<XNode> list, String namespace) {
        for (XNode context : list) {
            String id = context.getStringAttribute("id");
            this.configuration.getKeyGeneratorNames().remove(id + "!selectKey");
            this.configuration.getKeyGeneratorNames().remove(namespace + "." + id + "!selectKey");
        }
    }

    private void cleanSqlElement(List<XNode> list, String namespace) {
        for (XNode context : list) {
            String id = context.getStringAttribute("id");
            this.configuration.getSqlFragments().remove(id);
            this.configuration.getSqlFragments().remove(namespace + "." + id);
        }
    }
}

